/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.jei;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftoolscontrol.items.ModItems;
import mcjty.rftoolscontrol.items.craftingcard.CraftingCardContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSendRecipe
implements IMessage {
    private List<ItemStack> stacks;

    public void fromBytes(ByteBuf buf) {
        int l = buf.readInt();
        this.stacks = new ArrayList<ItemStack>(l);
        for (int i = 0; i < l; ++i) {
            if (buf.readBoolean()) {
                this.stacks.add(NetworkTools.readItemStack((ByteBuf)buf));
                continue;
            }
            this.stacks.add(ItemStackTools.getEmptyStack());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            if (ItemStackTools.isValid((ItemStack)stack)) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public PacketSendRecipe() {
    }

    public PacketSendRecipe(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public static class Handler
    implements IMessageHandler<PacketSendRecipe, IMessage> {
        public IMessage onMessage(PacketSendRecipe message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSendRecipe message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.func_130014_f_();
            ItemStack mainhand = player.func_184614_ca();
            if (ItemStackTools.isValid((ItemStack)mainhand) && mainhand.func_77973_b() == ModItems.craftingCardItem && player.field_71070_bA instanceof CraftingCardContainer) {
                CraftingCardContainer craftingCardContainer = (CraftingCardContainer)player.field_71070_bA;
                craftingCardContainer.setGridContents((EntityPlayer)player, message.stacks);
            }
        }
    }
}

