/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.moreBees.block;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.IHiveTile;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.Tabs;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.tiles.TileHive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import lach_01298.moreBees.MoreBees;
import lach_01298.moreBees.hives.MoreBeesHiveType;
import lach_01298.moreBees.item.ItemModelProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHive
extends BlockContainer
implements ItemModelProvider {
    private static final PropertyEnum<MoreBeesHiveType> HIVE_TYPES = PropertyEnum.func_177709_a((String)"hive", MoreBeesHiveType.class);
    private static String name;

    public BlockHive(String name) {
        super(Material.field_151575_d);
        BlockHive.name = name;
        this.func_149715_a(0.4f);
        this.func_149711_c(2.5f);
        this.func_149647_a(Tabs.tabApiculture);
        this.setHarvestLevel("scoop", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HIVE_TYPES, (Comparable)((Object)MoreBeesHiveType.ROCK)));
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileHive();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HIVE_TYPES});
    }

    public int func_176201_c(IBlockState state) {
        return ((MoreBeesHiveType)((Object)state.func_177229_b(HIVE_TYPES))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HIVE_TYPES, (Comparable)((Object)MoreBeesHiveType.VALUES[meta]));
    }

    public IBlockState getStateForType(@Nonnull MoreBeesHiveType type) {
        return this.func_176223_P().func_177226_a(HIVE_TYPES, (Comparable)((Object)type));
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        super.func_180649_a(world, pos, player);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHiveTile) {
            IHiveTile hive = (IHiveTile)tile;
            hive.onAttack(world, pos, player);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean canHarvest = this.canHarvestBlock((IBlockAccess)world, pos, player);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHiveTile) {
            IHiveTile hive = (IHiveTile)tile;
            hive.onBroken(world, pos, player, canHarvest);
        }
    }

    public String getNameFromMeta(int meta) {
        return IHiveRegistry.HiveType.VALUES[meta].func_176610_l();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        IBee bee;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random random = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        List<IHiveDrop> hiveDrops = BlockHive.getDropsForHive(this.func_176201_c(state));
        Collections.shuffle(hiveDrops);
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : hiveDrops) {
                if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
                bee = drop.getBeeType(world, pos);
                if ((double)random.nextFloat() < drop.getIgnobleChance(world, pos, fortune)) {
                    bee.setIsNatural(false);
                }
                ItemStack princess = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.PRINCESS);
                drops.add(princess);
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            bee = drop.getBeeType(world, pos);
            ItemStack drone = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.DRONE);
            drops.add(drone);
            break;
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            drops.addAll(drop.getExtraItems(world, pos, fortune));
            break;
        }
        return drops;
    }

    private static List<IHiveDrop> getDropsForHive(int meta) {
        String hiveName = BlockHive.getHiveNameForMeta(meta);
        if (hiveName == null) {
            return Collections.emptyList();
        }
        return PluginApiculture.hiveRegistry.getDrops(hiveName);
    }

    private static String getHiveNameForMeta(int meta) {
        return MoreBeesHiveType.VALUES[meta].getHiveUid();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void registerItemModel(Item itemBlock) {
        MoreBees.proxy.registerItemRenderer(itemBlock, 0, name);
    }
}

