/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.moreBees.Genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Arrays;
import java.util.Locale;
import lach_01298.moreBees.Register;

public enum BeeBranches implements IBranchDefinition
{
    ROCK("Petramis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeOre);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }
    }
    ,
    METAL("Metalis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeOre);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }
    }
    ,
    CRYSTAL("Crystalis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeOre);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        }
    }
    ,
    EARTH("Terris"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }
    }
    ,
    RADIOACTIVE("Radioactivis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeUranium);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)Register.effectRadiation);
        }
    }
    ,
    APOCALYTIC("Apocalytus"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeTNT);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGER);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_4);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectCreeper);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        }
    }
    ,
    AQUATIC("Aqus"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeWater);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
        }
    }
    ,
    WITHER("Witherris"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGEST);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_3);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_5);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)Register.effectWither);
        }
    }
    ,
    Slime("Slimeus"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeSlime);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)Register.effectSlimey);
        }
    };

    private final IClassification branch;
    private static IAllele[] defaultTemplate;

    private BeeBranches(String scientific) {
        this.branch = BeeManager.beeFactory.createBranch(this.name().toLowerCase(Locale.ENGLISH), scientific);
    }

    protected void setBranchProperties(IAllele[] template) {
    }

    public final IAllele[] getTemplate() {
        IAllele[] template = BeeBranches.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    public final IClassification getBranch() {
        return this.branch;
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectNone);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }
}

