/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.recipes.RecipeHandler;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.util.Platform;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public abstract class InscriberProcess
implements ICraftHandler,
IWebsiteSerializer {
    @Nullable
    private IIngredient imprintable;
    @Nullable
    private IIngredient topOptional;
    @Nullable
    private IIngredient botOptional;
    @Nullable
    private IIngredient output;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeError {
        if (output.size() != 1 || output.get(0).size() != 1) throw new RecipeError("Inscriber recipes must produce a single output.");
        if (input.size() != 1 || input.get(0).size() <= 1) throw new RecipeError("Inscriber recipes cannot have rows, and must have more then one input.");
        this.imprintable = input.get(0).get(0);
        this.topOptional = input.get(0).get(1);
        if (input.get(0).size() > 2) {
            this.botOptional = input.get(0).get(2);
        }
        this.output = output.get(0).get(0);
    }

    @Override
    public boolean canCraft(ItemStack reqOutput) throws RegistrationError, MissingIngredientError {
        return this.output != null && Platform.itemComparisons().isSameItem(this.output.getItemStack(), reqOutput);
    }

    @Override
    public String getPattern(RecipeHandler handler) {
        String pattern = "inscriber ";
        if (this.output != null) {
            pattern = pattern + (this.output.getQty() + 10);
            pattern = pattern + handler.getName(this.output) + '\n';
        }
        if (this.topOptional != null) {
            pattern = pattern + handler.getName(this.topOptional) + '\n';
        }
        if (this.imprintable != null) {
            pattern = pattern + handler.getName(this.imprintable);
        }
        if (this.botOptional != null) {
            pattern = pattern + '\n' + handler.getName(this.botOptional);
        }
        return pattern;
    }

    @Nullable
    protected IIngredient getImprintable() {
        return this.imprintable;
    }

    @Nullable
    protected IIngredient getTopOptional() {
        return this.topOptional;
    }

    @Nullable
    protected IIngredient getBotOptional() {
        return this.botOptional;
    }

    @Nullable
    protected IIngredient getOutput() {
        return this.output;
    }
}

