/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.main;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import elec332.core.api.IElecCoreMod;
import elec332.core.api.module.IModuleInfo;
import elec332.core.api.util.IDependencyHandler;
import elec332.core.compat.ModNames;
import elec332.core.main.ElecCore;
import elec332.core.util.FMLUtil;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;

class ModEventHooks {
    @Nonnull
    private final FMLModContainer modContainer;
    @Nullable
    private final IElecCoreMod elecCoreMod;
    @Nullable
    private final IDependencyHandler dependencyHandler;
    private static final ArtifactVersion actualForge;
    private static final ArtifactVersion actualElecCore;
    private static MissingModsException ex;
    private static final List<ModContainer> mc;
    private static final Field f;

    ModEventHooks(FMLModContainer modContainer) {
        this.modContainer = (FMLModContainer)Validate.notNull((Object)modContainer);
        this.elecCoreMod = modContainer.getMod() instanceof IElecCoreMod ? (IElecCoreMod)modContainer.getMod() : null;
        this.dependencyHandler = this.elecCoreMod != null ? this.elecCoreMod.getDependencyHandler() : null;
    }

    @Subscribe
    public void onConstuct(FMLConstructionEvent event) {
        if (this.dependencyHandler != null) {
            String other;
            String elecCore;
            String mcVersion = FMLUtil.getMcVersion();
            String forge = this.dependencyHandler.getRequiredForgeVersion(mcVersion);
            HashSet missing = Sets.newHashSet();
            if (!Strings.isNullOrEmpty((String)forge)) {
                ArtifactVersion reqForgeVer;
                if (!forge.startsWith("(") || !forge.startsWith("[")) {
                    forge = "[" + forge + ",)";
                }
                if (!(reqForgeVer = VersionParser.parseVersionReference((String)(ModNames.FORGE + "@" + forge))).containsVersion(actualForge)) {
                    missing.add(reqForgeVer);
                }
            }
            if (!Strings.isNullOrEmpty((String)(elecCore = this.dependencyHandler.getRequiredElecCoreVersion(mcVersion)))) {
                ArtifactVersion reqElecVer;
                if (!elecCore.startsWith("(") || !elecCore.startsWith("[")) {
                    elecCore = "[" + elecCore + ",)";
                }
                if (!(reqElecVer = VersionParser.parseVersionReference((String)("eleccore@" + elecCore))).containsVersion(actualElecCore)) {
                    missing.add(reqElecVer);
                }
            }
            if (!Strings.isNullOrEmpty((String)(other = this.dependencyHandler.getOtherDependencies(mcVersion)))) {
                List<ArtifactVersion> deps = IModuleInfo.parseDependencyInfo(other);
                for (ArtifactVersion version : deps) {
                    ModContainer mc = FMLUtil.findMod(version.getLabel());
                    if (mc != null && version.containsVersion(mc.getProcessedVersion())) continue;
                    missing.add(version);
                }
            }
            if (!missing.isEmpty()) {
                this.onVersionsNotFound(missing);
            }
        }
    }

    private void onVersionsNotFound(Set<ArtifactVersion> missing) {
        ElecCore.logger.error("The mod %s (%s) requires mod versions %s to be available", new Object[]{this.modContainer.getModId(), this.modContainer.getName(), missing});
        MissingModsException e = new MissingModsException(missing, this.modContainer.getModId(), this.modContainer.getName());
        if (FMLCommonHandler.instance().getSide().isClient()) {
            try {
                Field f = FMLClientHandler.class.getDeclaredField("modsMissing");
                f.setAccessible(true);
                f.set(FMLClientHandler.instance(), e);
            }
            catch (Exception exception) {}
        } else {
            throw e;
        }
        mc.add((ModContainer)this.modContainer);
        LogManager.getLogger((String)this.modContainer.getName()).info("Missing Mods Exception: ", (Throwable)e);
        ex = e;
    }

    static {
        mc = Lists.newArrayList();
        try {
            f = LoadController.class.getDeclaredField("modStates");
            f.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        actualForge = new DefaultArtifactVersion(ModNames.FORGE, ForgeVersion.getVersion());
        actualElecCore = new DefaultArtifactVersion("eleccore", "1.7.409");
        FMLUtil.getMainModBus().unregister((Object)FMLUtil.getLoadController());
        FMLUtil.getMainModBus().register(new Object(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Subscribe
            public void onPreInit(FMLPreInitializationEvent event) {
                if (ex == null) return;
                try {
                    for (ModContainer mod : mc) {
                        try {
                            Field f = LoadController.class.getDeclaredField("activeModList");
                            f.setAccessible(true);
                            ((List)f.get(FMLUtil.getLoadController())).remove(mod);
                            ((Multimap)f.get(FMLUtil.getLoadController())).put((Object)mod.getModId(), (Object)LoaderState.ModState.ERRORED);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        FMLUtil.getMainModBus().register((Object)FMLUtil.getLoadController());
    }
}

