/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.loading.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.api.client.model.loading.IItemModelHandler;
import elec332.core.api.client.model.loading.IModelHandler;
import elec332.core.api.client.model.loading.ModelHandler;
import elec332.core.client.model.RenderingRegistry;
import elec332.core.main.ElecCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ModelHandler
public class ItemModelHandler
implements IModelHandler {
    private List<IItemModelHandler> itemModelHandlers = Lists.newArrayList();
    private Map<Item, ModelResourceLocation> itemResourceLocations = Maps.newHashMap();

    @Override
    public void getModelHandlers(List<?> list) {
        for (Object o : list) {
            if (!(o instanceof IItemModelHandler)) continue;
            this.itemModelHandlers.add((IItemModelHandler)o);
        }
    }

    @Override
    public void registerModels() {
        ElecCore.logger.info("Prehandling Item Models");
        RenderItem renderItem = Minecraft.func_71410_x().field_175621_X;
        block0: for (Item item : RenderingRegistry.instance().getAllValidItems()) {
            for (IItemModelHandler handler : this.itemModelHandlers) {
                if (!handler.handleItem(item)) continue;
                String s = handler.getIdentifier(item);
                final ModelResourceLocation mr = new ModelResourceLocation(item.getRegistryName().toString(), s);
                renderItem.func_175037_a().func_178080_a(item, new ItemMeshDefinition(){

                    @Nonnull
                    public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                        return mr;
                    }
                });
                this.itemResourceLocations.put(item, mr);
                continue block0;
            }
        }
    }

    @Override
    public Map<ModelResourceLocation, IBakedModel> registerBakedModels(Function<ModelResourceLocation, IBakedModel> modelGetter) {
        HashMap ret = Maps.newHashMap();
        block0: for (Map.Entry<Item, ModelResourceLocation> entry : this.itemResourceLocations.entrySet()) {
            ModelResourceLocation mrl = entry.getValue();
            for (IItemModelHandler handler : this.itemModelHandlers) {
                if (!handler.handleItem(entry.getKey())) continue;
                ret.put(mrl, handler.getModelFor(entry.getKey(), mrl.func_177518_c(), mrl));
                continue block0;
            }
        }
        return ret;
    }
}

