/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.world.gen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOreSingleton
implements IWorldGenerator {
    private WorldGenerator gen;
    private Block blockOre;
    private int minHeight = 0;

    public WorldGenOreSingleton(Block ore, int mh) {
        this.blockOre = ore;
        this.minHeight = mh;
        this.gen = new WorldGenMinable(this.blockOre.func_176223_P(), 1, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int spawnTries = 50;
        if (0 == world.field_73011_w.getDimension()) {
            this.run(this.gen, world, random, chunkX * 16, chunkZ * 16, spawnTries, this.minHeight, 255);
        }
    }

    private void run(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            generator.func_180709_b(world, rand, pos);
        }
    }
}

