/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.tool;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.BaseItem;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAutoTorch
extends BaseItem
implements IHasRecipe {
    private static final int durability = 256;
    private static final float lightLimit = 7.0f;
    private static final int cooldown = 60;

    public ItemAutoTorch() {
        this.func_77625_d(1);
        this.func_77656_e(256);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        ActionType.tickTimeout(stack);
        if (ActionType.isOff(stack)) {
            return;
        }
        if (entityIn instanceof EntityPlayer && !world.field_72995_K) {
            EntityPlayer living = (EntityPlayer)entityIn;
            if (living.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                return;
            }
            BlockPos pos = living.func_180425_c();
            if ((float)world.func_175721_c(pos, true) < 7.0f && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && world.func_175623_d(pos) && UtilPlaceBlocks.placeStateSafe(world, living, pos, Blocks.field_150478_aa.func_176223_P())) {
                UtilItemStack.damageItem(living, stack);
                if (stack == null || stack.func_77952_i() == stack.func_77958_k()) {
                    stack = null;
                    living.field_71071_by.func_70299_a(itemSlot, null);
                    UtilSound.playSound(living, living.func_180425_c(), SoundEvents.field_187635_cQ, living.func_184176_by());
                }
                living.func_184811_cZ().func_185145_a((Item)this, 60);
            }
        }
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this) {
            if (ActionType.getTimeout(held) > 0) {
                return;
            }
            ActionType.setTimeout(held);
            event.setCanceled(true);
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.dcoin, SoundCategory.PLAYERS);
            if (!player.func_130014_f_().field_72995_K) {
                ActionType.toggle(held);
                UtilChat.addChatMessage(player, UtilChat.lang(ActionType.getName(held)));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TextFormatting.GREEN + UtilChat.lang(ActionType.getName(stack)));
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    @Override
    public void addRecipe() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"cic", " i ", "cic", Character.valueOf('c'), Blocks.field_150402_ci, Character.valueOf('i'), Blocks.field_150411_aY});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return !ActionType.isOff(stack);
    }

    public static enum ActionType {
        OFF,
        ON;

        private static final String NBT = "ActionType";
        private static final String NBTTIMEOUT = "timeout";

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            type = type == OFF.ordinal() ? ON.ordinal() : OFF.ordinal();
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }

        public static String getName(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return "tool.action." + ActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
            }
            catch (Exception e) {
                return "tool.action." + OFF.toString().toLowerCase();
            }
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }

        public static boolean isOff(ItemStack held) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
            int type = tags.func_74762_e(NBT);
            return type == OFF.ordinal();
        }
    }
}

