/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.registry.PotionEffectRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemPotionCustom
extends ItemFood {
    private ArrayList<Potion> potions = new ArrayList();
    private ArrayList<Integer> potionDurations = new ArrayList();
    private ArrayList<Integer> potionAmplifiers = new ArrayList();
    private boolean hasEffect;
    private String tooltip;

    public ItemPotionCustom(boolean shiny) {
        super(0, 0.0f, false);
        this.func_77848_i();
        this.func_77637_a(ModCyclic.TAB);
        this.func_77625_d(1);
        this.hasEffect = shiny;
    }

    public ItemPotionCustom(boolean shiny, Potion potionId, int potionDuration) {
        this(shiny, potionId, potionDuration, 0);
    }

    public ItemPotionCustom(boolean shiny, Potion potionId, int potionDuration, int potionAmplifier) {
        this(shiny, potionId, potionDuration, potionAmplifier, null);
    }

    public ItemPotionCustom(boolean shiny, Potion potionId, int potionDuration, int potionAmplifier, String t) {
        this(shiny);
        this.addEffect(potionId, potionDuration, potionAmplifier);
        this.tooltip = t;
    }

    public void addEffect(Potion potion, int potionDuration, int potionAmplifier) {
        this.potions.add(potion);
        this.potionDurations.add(potionDuration * 20);
        this.potionAmplifiers.add(potionAmplifier);
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        this.addAllEffects(world, (EntityLivingBase)player);
    }

    public void addAllEffects(World world, EntityLivingBase player) {
        for (int i = 0; i < this.potions.size(); ++i) {
            UtilEntity.addOrMergePotionEffect(player, new PotionEffect(this.potions.get(i), this.potionDurations.get(i).intValue(), this.potionAmplifiers.get(i).intValue()));
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_151686_a((ItemFood)this, stack);
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187664_bz, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_77849_c(stack, worldIn, entityplayer);
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    return new ItemStack(Items.field_151069_bo);
                }
                if (entityplayer != null) {
                    entityplayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                }
            }
        }
        return stack;
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return this.hasEffect;
    }

    public void func_77624_a(ItemStack held, EntityPlayer player, List<String> list, boolean par4) {
        for (int i = 0; i < this.potions.size(); ++i) {
            String n = TextFormatting.BLUE + UtilChat.lang(this.potions.get(i).func_76393_a());
            String slvl = PotionEffectRegistry.getStrForLevel(this.potionAmplifiers.get(i));
            n = n + " " + slvl + " (" + StringUtils.func_76337_a((int)this.potionDurations.get(i)) + ")";
            list.add(n);
        }
        if (this.tooltip != null) {
            list.add(UtilChat.lang(this.tooltip));
        }
    }
}

