/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.vector;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.tileentity.TileVector;
import com.lothrazar.cyclicmagic.gui.GuiBaseContainer;
import com.lothrazar.cyclicmagic.gui.GuiButtonMachineRedstone;
import com.lothrazar.cyclicmagic.gui.vector.ButtonVector;
import com.lothrazar.cyclicmagic.gui.vector.ContainerVector;
import com.lothrazar.cyclicmagic.gui.vector.GuiTextFieldInteger;
import com.lothrazar.cyclicmagic.net.PacketTileVector;
import com.lothrazar.cyclicmagic.util.Const;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiVector
extends GuiBaseContainer {
    private static final int SOUTH = 0;
    private static final int NORTH = 180;
    private static final int EAST = 270;
    private static final int WEST = 90;
    private TileVector tile;
    private int xAngle = 14;
    private int yAngle = 56;
    private int xPower = 14;
    private int yPower = 98;
    private int xYaw = 116;
    private int yYaw = 60;
    private ArrayList<GuiTextFieldInteger> txtBoxes = new ArrayList();
    private ButtonVector soundBtn;
    private GuiButtonMachineRedstone redstoneBtn;
    private GuiTextFieldInteger txtYaw;
    private GuiTextFieldInteger txtAngle;

    public GuiVector(InventoryPlayer inventoryPlayer, TileVector tileEntity) {
        super(new ContainerVector(inventoryPlayer, tileEntity), tileEntity);
        this.tile = tileEntity;
    }

    public String getTitle() {
        return "tile.plate_vector.name";
    }

    @Override
    public ResourceLocation getBackground() {
        return Const.Res.TABLEPLAIN;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneBtn = new GuiButtonMachineRedstone(0, this.field_147003_i + 6, this.field_147009_r + 6, this.tile.func_174877_v());
        this.redstoneBtn.setTextureIndex(this.tile.func_174887_a_(TileVector.Fields.REDSTONE.ordinal()));
        this.field_146292_n.add(this.redstoneBtn);
        int id = 1;
        this.txtAngle = this.addTextbox(id++, this.xAngle, this.yAngle, this.tile.getAngle() + "", 2);
        this.txtAngle.func_146195_b(true);
        this.txtAngle.setMaxVal(90);
        this.txtAngle.setMinVal(0);
        this.txtAngle.setTileFieldId(TileVector.Fields.ANGLE.ordinal());
        GuiTextFieldInteger txtPower = this.addTextbox(id++, this.xPower, this.yPower, this.tile.getPower() + "", 3);
        txtPower.setMaxVal(300);
        txtPower.setMinVal(1);
        txtPower.setTileFieldId(TileVector.Fields.POWER.ordinal());
        this.txtYaw = this.addTextbox(id++, this.xYaw, this.yYaw, this.tile.getYaw() + "", 3);
        this.txtYaw.setMaxVal(360);
        this.txtYaw.setMinVal(0);
        this.txtYaw.setTileFieldId(TileVector.Fields.YAW.ordinal());
        int btnYawSpacing = 22;
        this.addButtonAt((int)id++, (int)(this.xYaw + 5), (int)(this.yYaw + btnYawSpacing), (int)0, (int)TileVector.Fields.YAW.ordinal()).field_146126_j = "S";
        this.addButtonAt((int)id++, (int)(this.xYaw + 5), (int)(this.yYaw - btnYawSpacing), (int)180, (int)TileVector.Fields.YAW.ordinal()).field_146126_j = "N";
        this.addButtonAt((int)id++, (int)(this.xYaw + btnYawSpacing + 10), (int)this.yYaw, (int)270, (int)TileVector.Fields.YAW.ordinal()).field_146126_j = "E";
        this.addButtonAt((int)id++, (int)(this.xYaw - btnYawSpacing), (int)this.yYaw, (int)90, (int)TileVector.Fields.YAW.ordinal()).field_146126_j = "W";
        this.addButtonAt((int)id++, (int)(this.xYaw + btnYawSpacing + 10), (int)(this.yYaw - btnYawSpacing), (int)225, (int)TileVector.Fields.YAW.ordinal()).field_146126_j = "NE";
        this.addButtonAt((int)id++, (int)(this.xYaw - btnYawSpacing), (int)(this.yYaw - btnYawSpacing), (int)135, (int)TileVector.Fields.YAW.ordinal()).field_146126_j = "NW";
        this.addButtonAt((int)id++, (int)(this.xYaw + btnYawSpacing + 10), (int)(this.yYaw + btnYawSpacing), (int)315, (int)TileVector.Fields.YAW.ordinal()).field_146126_j = "SE";
        this.addButtonAt((int)id++, (int)(this.xYaw - btnYawSpacing), (int)(this.yYaw + btnYawSpacing), (int)45, (int)TileVector.Fields.YAW.ordinal()).field_146126_j = "SW";
        this.soundBtn = this.addButtonAt(id++, 134, 110, 0, TileVector.Fields.SOUND.ordinal());
        this.soundBtn.func_175211_a(34);
        this.addButtonAt((int)id++, (int)this.xAngle, (int)(this.yAngle - btnYawSpacing), (int)90, (int)TileVector.Fields.ANGLE.ordinal()).field_146126_j = "^";
        this.addButtonAt((int)id++, (int)(this.xAngle + 24), (int)(this.yAngle - btnYawSpacing), (int)45, (int)TileVector.Fields.ANGLE.ordinal()).field_146126_j = "/";
        this.addButtonAt((int)id++, (int)(this.xAngle + 24), (int)this.yAngle, (int)0, (int)TileVector.Fields.ANGLE.ordinal()).field_146126_j = "->";
    }

    private ButtonVector addButtonAt(int id, int x, int y, int val, int f) {
        ButtonVector btn = new ButtonVector(this.tile.func_174877_v(), id, this.field_147003_i + x, this.field_147009_r + y, val, f);
        this.field_146292_n.add(btn);
        return btn;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof ButtonVector) {
            ButtonVector btn = (ButtonVector)button;
            if (btn.getFieldId() == TileVector.Fields.SOUND.ordinal()) {
                int newVal = (this.tile.func_174887_a_(TileVector.Fields.SOUND.ordinal()) + 1) % 2;
                ModCyclic.network.sendToServer((IMessage)new PacketTileVector(this.tile.func_174877_v(), newVal, TileVector.Fields.SOUND.ordinal()));
            } else {
                for (GuiTextFieldInteger txt : this.txtBoxes) {
                    if (txt.getTileFieldId() != btn.getFieldId()) continue;
                    txt.func_146180_a(btn.getValue() + "");
                }
            }
        }
    }

    private GuiTextFieldInteger addTextbox(int id, int x, int y, String text, int maxLen) {
        int width = 10 * maxLen;
        int height = 20;
        GuiTextFieldInteger txt = new GuiTextFieldInteger(id, this.field_146289_q, x, y, width, height);
        txt.func_146203_f(maxLen);
        txt.func_146180_a(text);
        this.txtBoxes.add(txt);
        return txt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        for (GuiTextField guiTextField : this.txtBoxes) {
            if (guiTextField == null) continue;
            guiTextField.func_146194_f();
        }
        for (GuiButton guiButton : this.field_146292_n) {
            if (!(guiButton instanceof ButtonVector)) continue;
            ButtonVector btnv = (ButtonVector)guiButton;
            if (btnv.getFieldId() == TileVector.Fields.YAW.ordinal()) {
                btnv.field_146124_l = !this.txtYaw.func_146179_b().equals(btnv.getValue() + "");
                continue;
            }
            if (btnv.getFieldId() != TileVector.Fields.ANGLE.ordinal()) continue;
            btnv.field_146124_l = !this.txtAngle.func_146179_b().equals(btnv.getValue() + "");
        }
        this.redstoneBtn.setState(this.tile.func_174887_a_(TileVector.Fields.REDSTONE.ordinal()));
        this.soundBtn.field_146126_j = UtilChat.lang("tile.plate_vector.gui.sound" + this.tile.func_174887_a_(TileVector.Fields.SOUND.ordinal()));
        this.renderString("tile.plate_vector.gui.power", this.xPower + 14, this.yPower + 26);
        this.renderString("tile.plate_vector.gui.angle", this.xAngle + 18, this.yAngle + 26);
        super.func_146979_b(mouseX, mouseY);
    }

    private void renderString(String s, int x, int y) {
        String str = UtilChat.lang(s);
        int strWidth = this.field_146289_q.func_78256_a(str);
        this.field_146289_q.func_78276_b(str, x - strWidth / 2, y, 0x404040);
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField guiTextField : this.txtBoxes) {
            if (guiTextField == null) continue;
            guiTextField.func_146178_a();
        }
    }

    protected void func_73869_a(char pchar, int keyCode) throws IOException {
        super.func_73869_a(pchar, keyCode);
        for (GuiTextFieldInteger txt : this.txtBoxes) {
            String oldval = txt.func_146179_b();
            txt.func_146201_a(pchar, keyCode);
            String newval = txt.func_146179_b();
            boolean yes = false;
            try {
                int val = Integer.parseInt(newval);
                if (val <= txt.getMaxVal() && val >= txt.getMinVal()) {
                    yes = true;
                    this.tile.func_174885_b(txt.getTileFieldId(), val);
                    ModCyclic.network.sendToServer((IMessage)new PacketTileVector(this.tile.func_174877_v(), val, txt.getTileFieldId()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (yes || newval.isEmpty()) continue;
            txt.func_146180_a(oldval);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int btn) throws IOException {
        super.func_73864_a(mouseX, mouseY, btn);
        for (GuiTextField guiTextField : this.txtBoxes) {
            guiTextField.func_146192_a(mouseX, mouseY, btn);
            if (btn != 0) continue;
            boolean flag = mouseX >= this.field_147003_i + guiTextField.field_146209_f && mouseX < this.field_147003_i + guiTextField.field_146209_f + guiTextField.field_146218_h && mouseY >= this.field_147009_r + guiTextField.field_146210_g && mouseY < this.field_147009_r + guiTextField.field_146210_g + guiTextField.field_146219_i;
            guiTextField.func_146195_b(flag);
        }
    }
}

