/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityFan
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle {
    private static final int MIN_RANGE = 1;
    private static final int TIMER_FULL = 30;
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_REDST = "redstone";
    private static final String NBT_PART = "particles";
    private static final String NBT_PUSH = "pushpull";
    private static final String NBT_RANGE = "range";
    private static final int MAX_RANGE = 32;
    private int timer;
    private int needsRedstone = 1;
    private int pushIfZero = 0;
    private int particlesIfZero = 0;
    private int speedBase = 13;
    private int range = 16;

    public void func_73660_a() {
        if (!this.isRunning()) {
            this.timer = 0;
            return;
        }
        EnumFacing facing = this.getCurrentFacing();
        int rangeFixed = this.getCurrentRange();
        if (this.timer == 0) {
            this.timer = 30;
            if (this.particlesIfZero == 0) {
                this.doParticles(rangeFixed);
            }
        } else {
            --this.timer;
        }
        this.pushEntities(facing, rangeFixed);
    }

    private int pushEntities(EnumFacing facing, int rangeFixed) {
        BlockPos start = this.func_174877_v();
        BlockPos end = this.getCurrentFacingPos().func_177967_a(facing, rangeFixed).func_177984_a();
        switch (facing.func_176740_k()) {
            case X: {
                end = end.func_177982_a(0, 0, 1);
                break;
            }
            case Y: {
                break;
            }
            case Z: {
                end = end.func_177982_a(1, 0, 0);
                break;
            }
        }
        AxisAlignedBB region = new AxisAlignedBB(start, end);
        List nonPlayer = this.func_145831_w().func_72872_a(Entity.class, region);
        double x = (double)this.func_174877_v().func_177958_n() + 0.5;
        double y = (double)this.func_174877_v().func_177956_o() + 0.7;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5;
        float SPEED = this.getSpeedCalc();
        boolean pushIfFalse = this.pushIfZero != 0;
        UtilEntity.pullEntityList(x, y, z, pushIfFalse, nonPlayer, SPEED, SPEED);
        return nonPlayer.size();
    }

    private float getSpeedCalc() {
        return (float)this.speedBase / 100.0f;
    }

    private void doParticles(int rangeFixed) {
        EnumFacing facing = this.getCurrentFacing();
        for (int i = 1; i <= rangeFixed; ++i) {
            UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CLOUD, this.func_174877_v().func_177967_a(facing, i), 1);
        }
    }

    private int getCurrentRange() {
        EnumFacing facing = this.getCurrentFacing();
        for (int i = 1; i <= this.getRange(); ++i) {
            BlockPos tester = this.func_174877_v().func_177967_a(facing, i);
            if (this.canBlowThrough(tester)) continue;
            return i;
        }
        return this.getRange();
    }

    public int getRange() {
        return this.range;
    }

    private void setRange(int value) {
        this.range = Math.min(value, 32);
        if (this.range < 1) {
            this.range = 1;
        }
    }

    private boolean canBlowThrough(BlockPos tester) {
        return this.func_145831_w().func_175623_d(tester) || !this.func_145831_w().func_180495_p(tester).func_185913_b();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a(NBT_TIMER, this.timer);
        tags.func_74768_a(NBT_REDST, this.needsRedstone);
        tags.func_74768_a(NBT_PART, this.particlesIfZero);
        tags.func_74768_a(NBT_PUSH, this.pushIfZero);
        tags.func_74768_a(NBT_RANGE, this.range);
        return super.func_189515_b(tags);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e(NBT_TIMER);
        this.needsRedstone = tags.func_74762_e(NBT_REDST);
        this.particlesIfZero = tags.func_74762_e(NBT_PART);
        this.pushIfZero = tags.func_74762_e(NBT_PUSH);
        this.range = tags.func_74762_e(NBT_RANGE);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val % 2);
    }

    private void setShowParticles(int value) {
        this.particlesIfZero = value % 2;
    }

    private void setPushPull(int value) {
        this.pushIfZero = value % 2;
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
                case PARTICLES: {
                    return this.particlesIfZero;
                }
                case PUSHPULL: {
                    return this.pushIfZero;
                }
                case RANGE: {
                    return this.range;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case PARTICLES: {
                    this.setShowParticles(value);
                    break;
                }
                case PUSHPULL: {
                    this.setPushPull(value);
                    break;
                }
                case RANGE: {
                    this.setRange(value);
                }
            }
        }
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        PARTICLES,
        PUSHPULL,
        RANGE;

    }
}

