/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IStillManager;
import forestry.api.recipes.IStillRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.jei.still.StillRecipeWrapper;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker.mods.forestry.ForestryListAddition;
import modtweaker.mods.forestry.ForestryListRemoval;
import modtweaker.mods.forestry.recipes.StillRecipe;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Still")
public class Still {
    public static final String name = "Forestry Still";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, ILiquidStack fluidInput, int timePerUnit) {
        fluidOutput.amount(fluidOutput.getAmount() / 100);
        fluidInput.amount(fluidInput.getAmount() / 100);
        MineTweakerAPI.apply((IUndoableAction)new Add(new StillRecipe(timePerUnit, InputHelper.toFluid((ILiquidStack)fluidInput), InputHelper.toFluid((ILiquidStack)fluidOutput))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output, @Optional ILiquidStack fluidInput) {
        LinkedList<IStillRecipe> recipes = new LinkedList<IStillRecipe>();
        for (IStillRecipe r : RecipeManagers.stillManager.recipes()) {
            if (r == null || r.getOutput() == null || !StackHelper.matches((IIngredient)output, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)r.getOutput()))) continue;
            if (fluidInput != null) {
                if (!StackHelper.matches((IIngredient)fluidInput, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)r.getInput()))) continue;
                recipes.add(r);
                continue;
            }
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription((IIngredient)output)));
        }
    }

    private static class Remove
    extends ForestryListRemoval<IStillRecipe, IStillManager> {
        public Remove(List<IStillRecipe> recipes) {
            super(Still.name, RecipeManagers.stillManager, recipes);
        }

        @Override
        public String getRecipeInfo(IStillRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getOutput());
        }

        @Override
        public IRecipeWrapper wrapRecipe(IStillRecipe recipe) {
            return new StillRecipeWrapper(recipe);
        }
    }

    private static class Add
    extends ForestryListAddition<IStillRecipe> {
        public Add(IStillRecipe recipe) {
            super(Still.name, (ICraftingProvider)RecipeManagers.stillManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IStillRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getOutput());
        }

        @Override
        public IRecipeWrapper wrapRecipe(IStillRecipe recipe) {
            return new StillRecipeWrapper(recipe);
        }
    }
}

