/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IMoistenerManager;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker.mods.forestry.ForestryListAddition;
import modtweaker.mods.forestry.ForestryListRemoval;
import modtweaker.mods.forestry.recipes.MoistenerRecipe;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Moistener")
public class Moistener {
    public static final String name = "Forestry Moistener";
    public static final String nameFuel = "Forestry Moistener (Fuel)";

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int packagingTime) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MoistenerRecipe(InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)output), packagingTime)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<IMoistenerRecipe> recipes = new LinkedList<IMoistenerRecipe>();
        for (IMoistenerRecipe recipe : RecipeManagers.moistenerManager.recipes()) {
            if (recipe == null || recipe.getProduct() == null || !StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getProduct()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(IItemStack item, IItemStack product, int moistenerValue, int stage) {
        if (stage >= 0) {
            MineTweakerAPI.apply((IUndoableAction)new AddFuel(new MoistenerFuel(InputHelper.toStack((IItemStack)item), InputHelper.toStack((IItemStack)product), moistenerValue, stage)));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe add for %s. Stage parameter must positive!", name, item.toString()));
        }
    }

    @ZenMethod
    public static void removeFuel(IIngredient moistenerItem) {
        HashMap<ItemStack, MoistenerFuel> fuelItems = new HashMap<ItemStack, MoistenerFuel>();
        for (Map.Entry fuelItem : FuelManager.moistenerResource.entrySet()) {
            if (fuelItem == null || !StackHelper.matches((IIngredient)moistenerItem, (IItemStack)InputHelper.toIItemStack((ItemStack)((MoistenerFuel)fuelItem.getValue()).getItem()))) continue;
            fuelItems.put((ItemStack)fuelItem.getKey(), (MoistenerFuel)fuelItem.getValue());
        }
        if (!fuelItems.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuelItems));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, moistenerItem.toString()));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<ItemStack, MoistenerFuel> {
        public RemoveFuel(Map<ItemStack, MoistenerFuel> recipes) {
            super(Moistener.nameFuel, FuelManager.moistenerResource, recipes);
        }

        public String getRecipeInfo(Map.Entry<ItemStack, MoistenerFuel> fuelEntry) {
            return LogHelper.getStackDescription((Object)fuelEntry.getKey());
        }
    }

    private static class AddFuel
    extends BaseMapAddition<ItemStack, MoistenerFuel> {
        public AddFuel(MoistenerFuel fuelEntry) {
            super(Moistener.nameFuel, FuelManager.moistenerResource);
            this.recipes.put(fuelEntry.getItem(), fuelEntry);
        }

        public String getRecipeInfo(Map.Entry<ItemStack, MoistenerFuel> fuelEntry) {
            return LogHelper.getStackDescription((Object)fuelEntry.getKey());
        }
    }

    private static class Remove
    extends ForestryListRemoval<IMoistenerRecipe, IMoistenerManager> {
        public Remove(List<IMoistenerRecipe> recipes) {
            super(Moistener.name, RecipeManagers.moistenerManager, recipes);
        }

        @Override
        public String getRecipeInfo(IMoistenerRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getProduct());
        }

        @Override
        public IRecipeWrapper wrapRecipe(IMoistenerRecipe recipe) {
            return null;
        }
    }

    private static class Add
    extends ForestryListAddition<IMoistenerRecipe> {
        public Add(IMoistenerRecipe recipe) {
            super(Moistener.name, (ICraftingProvider)RecipeManagers.moistenerManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IMoistenerRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getProduct());
        }

        @Override
        public IRecipeWrapper wrapRecipe(IMoistenerRecipe recipe) {
            return null;
        }
    }
}

