/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.world.entity.EntityPirate;
import vazkii.quark.world.feature.PirateShips;

public class PirateShipGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer sWorld = (WorldServer)world;
        int x = chunkX * 16 + random.nextInt(16);
        BlockPos xzPos = new BlockPos(x, 1, z = chunkZ * 16 + random.nextInt(16));
        Biome biome = world.getBiomeForCoordsBody(xzPos);
        if ((biome == Biomes.field_76771_b || biome == Biomes.field_150575_M) && random.nextInt(PirateShips.rarity) == 0) {
            BlockPos pos = PirateShipGenerator.getTopLiquidBlock(world, new BlockPos(x, 0, z));
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            if (state.func_177230_c() != Blocks.field_150355_j) {
                return;
            }
            pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 3, pos.func_177952_p());
            PirateShipGenerator.generateShipAt(sWorld, random, pos);
        }
    }

    public static void generateShipAt(WorldServer world, Random random, BlockPos pos) {
        MinecraftServer server = world.func_73046_m();
        Template template = world.func_184163_y().func_189942_b(server, PirateShips.SHIP_STRUCTURE);
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(Rotation.values()[random.nextInt(Rotation.values().length)]);
        BlockPos size = template.func_186259_a();
        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    BlockPos checkPos = pos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(x, y, z)));
                    IBlockState checkState = world.func_180495_p(checkPos);
                    if (checkState.func_177230_c().isAir(checkState, (IBlockAccess)world, checkPos) || checkState.func_177230_c() == Blocks.field_150355_j) continue;
                    return;
                }
            }
        }
        template.func_186253_b((World)world, pos, settings);
        Map dataBlocks = template.func_186258_a(pos, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            String[] tokens = ((String)entry.getValue()).split(" ");
            if (tokens.length == 0) {
                return;
            }
            BlockPos dataPos = (BlockPos)entry.getKey();
            switch (tokens[0]) {
                case "captain_pirate": {
                    EntityPirate pirate = new EntityPirate((World)world);
                    pirate.func_70107_b((double)dataPos.func_177958_n() + 0.5, dataPos.func_177956_o(), (double)dataPos.func_177952_p() + 0.5);
                    pirate.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
                    pirate.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u));
                    pirate.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(PirateShips.pirate_hat));
                    world.func_72838_d((Entity)pirate);
                    break;
                }
                case "bow_pirate": {
                    EntityPirate pirate = new EntityPirate((World)world);
                    pirate.func_70107_b((double)dataPos.func_177958_n() + 0.5, dataPos.func_177956_o(), (double)dataPos.func_177952_p() + 0.5);
                    pirate.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                    pirate.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(PirateShips.pirate_hat));
                    world.func_72838_d((Entity)pirate);
                    break;
                }
                case "sword_pirate": {
                    EntityPirate pirate = new EntityPirate((World)world);
                    pirate.func_70107_b((double)dataPos.func_177958_n() + 0.5, dataPos.func_177956_o(), (double)dataPos.func_177952_p() + 0.5);
                    pirate.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                    pirate.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(PirateShips.pirate_hat));
                    world.func_72838_d((Entity)pirate);
                    break;
                }
                case "booty": {
                    float chance;
                    float f = chance = tokens.length == 3 ? 1.0f : 0.75f;
                    if (random.nextFloat() > chance) break;
                    String chestOrientation = tokens[1];
                    EnumFacing chestFacing = settings.func_186215_c().func_185831_a(EnumFacing.func_176739_a((String)chestOrientation));
                    IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)chestFacing);
                    world.func_175656_a(dataPos, chestState);
                    TileEntity tile = world.func_175625_s(dataPos);
                    if (tile == null || !(tile instanceof TileEntityLockableLoot)) break;
                    ((TileEntityLockableLoot)tile).func_189404_a(PirateShips.PIRATE_CHEST_LOOT_TABLE, random.nextLong());
                    break;
                }
                case "cannon": {
                    String dispenserOrientation = tokens[1];
                    EnumFacing dispenserFacing = settings.func_186215_c().func_185831_a(EnumFacing.func_176739_a((String)dispenserOrientation));
                    IBlockState dispenserState = Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)dispenserFacing);
                    world.func_175656_a(dataPos, dispenserState);
                    TileEntityDispenser dispenser = (TileEntityDispenser)world.func_175625_s(dataPos);
                    if (dispenser == null) break;
                    dispenser.func_70299_a(random.nextInt(9), new ItemStack(Items.field_151059_bz, 5 + random.nextInt(20)));
                }
            }
        }
    }

    private static BlockPos getTopLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !((state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_177230_c() instanceof BlockLiquid)) {
            blockpos = blockpos1;
        }
        return blockpos;
    }
}

