/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.model;

import com.google.common.collect.Lists;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.model.CollectedItemQuadBakedBlockModel;
import crazypants.enderio.render.property.EnumRenderPart;
import crazypants.enderio.render.util.ItemQuadCollector;
import crazypants.util.Prep;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class FacadeSmartItemModel
implements IPerspectiveAwareModel {
    private final IPerspectiveAwareModel parent;
    private final ItemOverrideList overrides = new ItemOverrideList(Lists.newArrayList()){

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            IBlockState paintSource;
            if (originalModel == null || Prep.isInvalid(stack)) {
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            if (!YetaUtil.shouldHeldItemHideFacadesClient() && (paintSource = PainterUtil2.getSourceBlock(stack)) != null) {
                ItemQuadCollector quads = new ItemQuadCollector();
                quads.addItemBlockState(paintSource, null);
                quads.addBlockState(BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY)), null);
                return new CollectedItemQuadBakedBlockModel(originalModel, quads);
            }
            return originalModel;
        }
    };

    public FacadeSmartItemModel(IPerspectiveAwareModel parent) {
        this.parent = parent;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.parent.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return this.parent.handlePerspective(cameraTransformType);
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }
}

