/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.ChatUtil;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.tool.IHideFacades;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.item.PacketConduitProbe;
import crazypants.enderio.item.PacketConduitProbeMode;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.render.IHaveRenderers;
import crazypants.util.ClientUtil;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemConduitProbe
extends Item
implements IResourceTooltipProvider,
IHideFacades,
IHaveRenderers {
    public static ItemConduitProbe create() {
        PacketHandler.INSTANCE.registerMessage(PacketConduitProbe.class, PacketConduitProbe.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketConduitProbeMode.class, PacketConduitProbeMode.class, PacketHandler.nextID(), Side.SERVER);
        ItemConduitProbe result = new ItemConduitProbe();
        result.init();
        return result;
    }

    public static boolean copyPasteSettings(EntityPlayer player, ItemStack stack, IConduitBundle bundle, EnumFacing dir) {
        boolean isCopy = player.func_70093_af();
        boolean clearedData = false;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        boolean performedAction = false;
        Collection<IConduit> conduits = bundle.getConduits();
        for (IConduit conduit : conduits) {
            if (!conduit.getExternalConnections().contains(dir)) continue;
            if (isCopy && !clearedData) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
                clearedData = true;
            }
            if (isCopy) {
                performedAction |= conduit.writeConnectionSettingsToNBT(dir, nbt);
                continue;
            }
            performedAction |= conduit.readConduitSettingsFromNBT(dir, nbt);
        }
        if (isCopy && performedAction && player.field_70170_p.field_72995_K) {
            ChatUtil.sendNoSpamClient((String[])new String[]{"Copied conduit settings"});
        }
        return performedAction;
    }

    protected ItemConduitProbe() {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77655_b("enderio." + ModObject.itemConduitProbe.getUnlocalisedName());
        this.setRegistryName(ModObject.itemConduitProbe.name());
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(ItemStack itemStack, EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (itemStack.func_77952_i() == 0 && PacketConduitProbe.canCreatePacket(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            if (world.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbe(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_77658_a();
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        ClientUtil.regRenderer((Item)this, 0, ModObject.itemConduitProbe.getUnlocalisedName());
        ClientUtil.regRenderer((Item)this, 1, ModObject.itemConduitProbe.getUnlocalisedName() + "Variant");
    }
}

