/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import mcjty.rftools.blocks.shield.AbstractShieldBlock;
import mcjty.rftools.blocks.shield.NoTickShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.ShieldSetup;
import mcjty.rftools.blocks.shield.TickShieldSolidBlockTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SolidShieldBlock
extends AbstractShieldBlock {
    public static final PropertyInteger ICON_TOPDOWN = PropertyInteger.func_177719_a((String)"icontopdown", (int)0, (int)5);
    public static final PropertyInteger ICON_SIDE = PropertyInteger.func_177719_a((String)"iconside", (int)0, (int)5);

    @Override
    protected void init() {
        this.setRegistryName("solid_shield_block");
        this.func_149663_c("rftools.solid_shield_block");
    }

    @SideOnly(value=Side.CLIENT)
    public void initBlockColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                TileEntity te;
                if (pos != null && worldIn != null && (te = worldIn.func_175625_s(pos)) instanceof NoTickShieldBlockTileEntity) {
                    NoTickShieldBlockTileEntity tileEntity = (NoTickShieldBlockTileEntity)te;
                    return tileEntity.getShieldColor();
                }
                return 0xFFFFFF;
            }
        }, new Block[]{this});
    }

    @Override
    protected void initTE() {
        GameRegistry.registerTileEntity(TickShieldSolidBlockTileEntity.class, (String)("rftools_" + this.getRegistryName()));
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TickShieldSolidBlockTileEntity();
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block block = world.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        return block != ShieldSetup.solidShieldBlock && block != ShieldSetup.noTickSolidShieldBlock;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof NoTickShieldBlockTileEntity) {
            NoTickShieldBlockTileEntity tileEntity2 = (NoTickShieldBlockTileEntity)te;
            ShieldRenderingMode mode = tileEntity2.getShieldRenderingMode();
            if (mode == ShieldRenderingMode.MODE_TRANSP) {
                return state.func_177226_a((IProperty)ICON_TOPDOWN, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)ICON_SIDE, (Comparable)Integer.valueOf(4));
            }
            if (mode == ShieldRenderingMode.MODE_SOLID) {
                return state.func_177226_a((IProperty)ICON_TOPDOWN, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)ICON_SIDE, (Comparable)Integer.valueOf(5));
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int topdown = (z & 1) * 2 + (x & 1);
        int side = (y & 1) * 2 + (x + z & 1);
        return state.func_177226_a((IProperty)ICON_TOPDOWN, (Comparable)Integer.valueOf(topdown)).func_177226_a((IProperty)ICON_SIDE, (Comparable)Integer.valueOf(side));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ICON_TOPDOWN, ICON_SIDE});
    }
}

