/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.counter;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.network.clientinfo.PacketGetInfoFromServer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.counter.CounterInfoPacketClient;
import mcjty.rftools.blocks.logic.counter.CounterInfoPacketServer;
import mcjty.rftools.blocks.logic.counter.CounterTileEntity;
import mcjty.rftools.blocks.logic.counter.GuiCounter;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class CounterBlock
extends LogicSlabBlock<CounterTileEntity, EmptyContainer> {
    private static long lastTime = 0L;

    public CounterBlock() {
        super(Material.field_151573_f, "counter_block", CounterTileEntity.class, EmptyContainer.class);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiCounter.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int counter = tagCompound.func_74762_e("counter");
            list.add(TextFormatting.GREEN + "Counter: " + counter);
            int current = tagCompound.func_74762_e("current");
            list.add(TextFormatting.GREEN + "Current: " + current);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block counts redstone pulses and emits");
            list.add(TextFormatting.WHITE + "a signal once a certain number has been reached.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected void clOnNeighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn) {
        super.clOnNeighborChanged(state, world, pos, blockIn);
        CounterTileEntity counterTileEntity = (CounterTileEntity)world.func_175625_s(pos);
        counterTileEntity.update();
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof CounterTileEntity) {
            CounterTileEntity counterTileEntity = (CounterTileEntity)te;
            probeInfo.text(TextFormatting.GREEN + "Current: " + counterTileEntity.getCurrent());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        if (System.currentTimeMillis() - lastTime > 500L) {
            CounterTileEntity te = (CounterTileEntity)accessor.getTileEntity();
            lastTime = System.currentTimeMillis();
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new CounterInfoPacketServer(te.func_145831_w().field_73011_w.getDimension(), te.func_174877_v())));
        }
        currenttip.add(TextFormatting.GREEN + "Current: " + CounterInfoPacketClient.cntReceived);
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_COUNTER;
    }
}

