/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import reborncore.common.tile.TileBase;
import reborncore.common.util.IInventoryUpdateable;

public class Inventory
implements IInventory {
    private final String inventoryName;
    private final int inventorySize;
    private final int inventoryStackLimit;
    private final ItemStack[] inventoryContent;
    private TileBase tileBase;
    public boolean isDirty;

    public Inventory(String inventoryName, int inventorySize, int inventoryStackLimit, TileBase tileBase) {
        this.inventoryName = inventoryName;
        this.inventorySize = inventorySize;
        this.inventoryStackLimit = inventoryStackLimit;
        this.inventoryContent = new ItemStack[this.func_70302_i_()];
        this.tileBase = tileBase;
    }

    public int func_70302_i_() {
        return this.inventorySize;
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventoryContent[slotId];
    }

    public ItemStack func_70298_a(int slotId, int count) {
        if (slotId < this.func_70302_i_()) {
            ItemStack stack = this.func_70301_a(slotId);
            if (stack != null && stack.field_77994_a > count) {
                ItemStack result = stack.func_77979_a(count);
                this.func_70296_d();
                return result;
            }
            this.func_70299_a(slotId, null);
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        if (slotId < this.func_70302_i_()) {
            this.inventoryContent[slotId] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return this.inventoryStackLimit;
    }

    public void func_70296_d() {
        if (this.tileBase instanceof IInventoryUpdateable) {
            ((IInventoryUpdateable)((Object)this.tileBase)).updateInventory();
        }
        this.tileBase.markBlockForUpdate();
        this.isDirty = true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void readFromNBT(NBTTagCompound data) {
        NBTTagList nbttaglist = data.func_150295_c("inventory_" + this.func_70005_c_(), 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound slot = nbttaglist.func_150305_b(i);
            int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
            if (index < 0 || index >= this.func_70302_i_()) continue;
            this.func_70299_a(index, ItemStack.func_77949_a((NBTTagCompound)slot));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagList slots = new NBTTagList();
        for (byte index = 0; index < this.func_70302_i_(); index = (byte)((byte)(index + 1))) {
            ItemStack stack = this.func_70301_a(index);
            if (stack == null || stack.field_77994_a <= 0) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slots.func_74742_a((NBTBase)slot);
            slot.func_74774_a("Slot", index);
            stack.func_77955_b(slot);
        }
        data.func_74782_a("inventory_" + this.func_70005_c_(), (NBTBase)slots);
        return data;
    }

    public ItemStack func_70304_b(int slotId) {
        if (slotId >= this.func_70302_i_() || this.func_70301_a(slotId) == null) {
            return null;
        }
        ItemStack stackToTake = this.func_70301_a(slotId);
        this.func_70299_a(slotId, null);
        return stackToTake;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.inventoryContent[i] = null;
        }
    }

    public String func_70005_c_() {
        return this.inventoryName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }
}

