/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.guibuilder;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.client.config.GuiUtils;
import reborncore.client.RenderUtil;

public class GuiBuilder {
    static ResourceLocation resourceLocation;
    public static final ResourceLocation defaultTextureSheet;

    public GuiBuilder(ResourceLocation resourceLocation) {
        GuiBuilder.resourceLocation = resourceLocation;
    }

    public void drawDefaultBackground(GuiScreen gui, int x, int y, int width, int height) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        gui.func_73729_b(x, y, 0, 0, width / 2, height / 2);
        gui.func_73729_b(x + width / 2, y, 150 - width / 2, 0, width / 2, height / 2);
        gui.func_73729_b(x, y + height / 2, 0, 150 - height / 2, width / 2, height / 2);
        gui.func_73729_b(x + width / 2, y + height / 2, 150 - width / 2, 150 - height / 2, width / 2, height / 2);
    }

    public void drawEnergyBar(GuiScreen gui, int x, int y, int height, int energyStored, int maxEnergyStored, int mouseX, int mouseY, String powerType) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        gui.func_73729_b(x, y, 0, 150, 14, height);
        gui.func_73729_b(x, y + height - 1, 0, 255, 14, 1);
        int draw = (int)((double)energyStored / (double)maxEnergyStored * (double)(height - 2));
        gui.func_73729_b(x + 1, y + height - draw - 1, 14, height + 150 - draw, 12, draw);
        if (this.isInRect(x, y, 14, height, mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(energyStored + " / " + maxEnergyStored + " " + powerType);
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)gui.field_146294_l, (int)gui.field_146295_m, (int)-1, (FontRenderer)gui.field_146297_k.field_71466_p);
            GlStateManager.func_179140_f();
        }
    }

    public void drawPlayerSlots(GuiScreen gui, int posX, int posY, boolean center) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        if (center) {
            posX -= 81;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                gui.func_73729_b(posX + x * 18, posY + y * 18, 150, 0, 18, 18);
            }
        }
        for (int x = 0; x < 9; ++x) {
            gui.func_73729_b(posX + x * 18, posY + 58, 150, 0, 18, 18);
        }
    }

    public void drawSlot(GuiScreen gui, int posX, int posY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        gui.func_73729_b(posX, posY, 150, 0, 18, 18);
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public void drawString(GuiScreen gui, String string, int x, int y) {
        gui.field_146297_k.field_71466_p.func_78276_b(string, x, y, 0xFFFFFF);
    }

    public void drawProgressBar(GuiScreen gui, double progress, int x, int y) {
        gui.field_146297_k.func_110434_K().func_110577_a(resourceLocation);
        gui.func_73729_b(x, y, 150, 18, 22, 15);
        int j = (int)progress;
        if (j > 0) {
            gui.func_73729_b(x, y, 150, 34, j + 1, 15);
        }
    }

    public void drawTank(GuiScreen gui, FluidTank tank, int x, int y, float zLevel, int width, int height, int mouseX, int mouseY) {
        RenderUtil.renderGuiTank(tank, x, y, zLevel, width, height);
        if (this.isInRect(x, y, 14, height, mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            if (tank.getFluid() != null) {
                list.add(tank.getFluidAmount() + " / " + tank.getCapacity() + " " + tank.getFluid().getLocalizedName());
            } else {
                list.add("empty");
            }
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)gui.field_146294_l, (int)gui.field_146295_m, (int)-1, (FontRenderer)gui.field_146297_k.field_71466_p);
            GlStateManager.func_179140_f();
        }
    }

    public void drawBurnBar(GuiScreen gui, double progress, int x, int y) {
        gui.field_146297_k.func_110434_K().func_110577_a(resourceLocation);
        gui.func_73729_b(x, y, 150, 49, 22, 15);
        int j = (int)progress;
        if (j > 0) {
            gui.func_73729_b(x, y, 150, 64, 15, j + 1);
        }
    }

    public void drawOutputSlot(GuiScreen gui, int x, int y) {
        gui.field_146297_k.func_110434_K().func_110577_a(resourceLocation);
        gui.func_73729_b(x, y, 174, 0, 26, 26);
    }

    public void drawInfoButton(int buttonID, int x, int y, List<GuiButton> buttonList) {
        buttonList.add(new GuiButton(0, x, y, 20, 20, "i"));
    }

    public void handleInfoButtonClick(int buttonID, List<GuiButton> buttonList) {
    }

    public void drawInfo(GuiScreen gui, int x, int y, int height, int width, boolean draw) {
        if (draw) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
            gui.func_73729_b(x, y, 0, 0, width / 2, height / 2);
            gui.func_73729_b(x + width / 2, y, 150 - width / 2, 0, width / 2, height / 2);
            gui.func_73729_b(x, y + height / 2, 0, 150 - height / 2, width / 2, height / 2);
            gui.func_73729_b(x + width / 2, y + height / 2, 150 - width / 2, 150 - height / 2, width / 2, height / 2);
        }
    }

    static {
        defaultTextureSheet = new ResourceLocation("reborncore", "textures/gui/guiElements.png");
    }
}

