/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.core.api.BitBrush;
import mod.chiselsandbits.helpers.ModUtil;
import mods.belgabor.bitdrawers.BitDrawers;
import mods.belgabor.bitdrawers.core.BDLogger;
import mods.belgabor.bitdrawers.core.BitHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ILockableContainer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileBitController
extends TileEntityController
implements IProtectable {
    protected Map<Integer, List<TileEntityController.SlotRecord>> drawerBitLookup = new HashMap<Integer, List<TileEntityController.SlotRecord>>();
    private String securityKey;

    public int interactPutItemsIntoInventory(EntityPlayer player) {
        int count = 0;
        ItemStack currentStack = player.field_71071_by.func_70448_g();
        if (!BitDrawers.config.allowBagMultiInsertion) {
            if (currentStack != null) {
                count = this.insertBagItems(currentStack, player.func_146103_bH());
            }
            if (count < 0) {
                count = 0;
            }
        }
        count += super.interactPutItemsIntoInventory(player);
        if (!BitDrawers.config.allowChiseledBlockMultiInsertion) {
            currentStack = player.field_71071_by.func_70448_g();
            if (currentStack != null) {
                count = this.insertChiseledBlocks(currentStack, player.func_146103_bH());
                if (currentStack.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
            if (count < 0) {
                count = 0;
            }
        }
        return count;
    }

    protected int insertItems(ItemStack stack, GameProfile profile) {
        if (stack == null) {
            return 0;
        }
        int count = -1;
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitController:insertItems %s", stack == null ? "null" : stack.func_82833_r());
        }
        if (BitDrawers.config.allowBagMultiInsertion) {
            count = this.insertBagItems(stack, profile);
        }
        if (count < 0) {
            count = super.insertItems(stack, profile);
            if (stack.field_77994_a > 0 && BitDrawers.config.allowChiseledBlockMultiInsertion) {
                count = this.insertChiseledBlocks(stack, profile);
            }
        }
        return count > 0 ? count : 0;
    }

    protected int insertBagItems(ItemStack stack, GameProfile profile) {
        int count = 0;
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitController:insertBagItems %s", stack == null ? "null" : stack.func_82833_r());
        }
        if (stack != null && stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            block0: for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extract;
                while ((extract = handler.extractItem(i, 64, true)) != null) {
                    int extracted = extract.field_77994_a;
                    int inserted = this.insertItems(extract, profile);
                    if (inserted > 0) {
                        count += inserted;
                        ItemStack test = handler.extractItem(i, inserted, false);
                        if (test.field_77994_a < inserted) {
                            BDLogger.error("Could not extract simulated amount from bag. Something went very wrong.", new Object[0]);
                        }
                    }
                    if (inserted >= extracted) continue;
                    continue block0;
                }
            }
        } else {
            count = -1;
        }
        return count;
    }

    protected int insertChiseledBlocks(ItemStack stack, GameProfile profile) {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitController:insertChiseledBlocks %s", stack == null ? "null" : stack.func_82833_r());
        }
        if (stack == null) {
            return 0;
        }
        if (BitDrawers.cnb_api.getItemType(stack) == ItemType.CHISLED_BLOCK) {
            IBitAccess access = BitDrawers.cnb_api.createBitItem(stack);
            if (access == null) {
                return 0;
            }
            BitHelper.BitCounter counter = new BitHelper.BitCounter();
            access.visitBits((IBitVisitor)counter);
            List<BitCollectorData> data = null;
            try {
                data = BitCollectorData.collect(counter);
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                BDLogger.error("Failed to create bit brush for stored bit", new Object[0]);
                BDLogger.error(invalidBitItem);
                return 0;
            }
            data.stream().forEachOrdered(bitData -> {
                for (Integer slot : this.enumerateDrawersForInsertion(bitData.stack, true)) {
                    IDrawerGroup group = this.getGroupForDrawerSlot(slot);
                    if (group instanceof IProtectable && !SecurityManager.hasAccess((GameProfile)profile, (IProtectable)((IProtectable)group))) continue;
                    IDrawer drawer = this.getDrawer(slot);
                    ItemStack itemProto = drawer.getStoredItemPrototype();
                    if (itemProto == null) break;
                    bitData.drawers.add(drawer);
                    if (bitData.canStore < 0) continue;
                    if (drawer instanceof IVoidable && ((IVoidable)drawer).isVoid()) {
                        bitData.canStore = -1;
                        continue;
                    }
                    bitData.canStore += drawer.getRemainingCapacity();
                }
                bitData.calc();
            });
            OptionalInt test = data.stream().mapToInt(x -> x.canStoreItems).min();
            int maxItems = Math.min(test.isPresent() ? test.getAsInt() : 0, stack.field_77994_a);
            if (maxItems == 0) {
                if (BitDrawers.config.debugTrace) {
                    BDLogger.info("TileBitController:insertChiseledBlocks No Space", new Object[0]);
                }
                return 0;
            }
            data.stream().forEachOrdered(bitData -> {
                bitData.toStore(maxItems);
                bitData.drawers.stream().forEachOrdered(drawer -> {
                    if (bitData.toStore > 0) {
                        int stored = this.insertItemsIntoDrawer((IDrawer)drawer, bitData.toStore);
                        if (drawer instanceof IVoidable && ((IVoidable)drawer).isVoid()) {
                            bitData.toStore = 0;
                        } else {
                            bitData.stored(stored);
                        }
                    }
                });
            });
            OptionalInt left = data.stream().mapToInt(x -> x.toStore).max();
            if (left.isPresent() && left.getAsInt() > 0) {
                BDLogger.error("Couldn't store bits when inserting chiseled block. This is not supposed to happen at this point.", new Object[0]);
            }
            stack.field_77994_a -= maxItems;
            return maxItems;
        }
        return -1;
    }

    protected void resetCache() {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitController:resetCache", new Object[0]);
        }
        this.drawerBitLookup.clear();
        super.resetCache();
    }

    public void updateCache() {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitController:updateCache", new Object[0]);
        }
        super.updateCache();
        this.rebuildBitLookup(this.drawerBitLookup, this.drawerSlotList);
    }

    protected void rebuildBitLookup(Map<Integer, List<TileEntityController.SlotRecord>> lookup, List<TileEntityController.SlotRecord> records) {
        lookup.clear();
        boolean invBased = false;
        for (int i = 0; i < records.size(); ++i) {
            ItemStack item;
            IDrawer drawer;
            int drawerSlot;
            TileEntityController.SlotRecord record = records.get(i);
            IDrawerGroup group = this.getGroupForSlotRecord(record);
            if (group == null) continue;
            int n = drawerSlot = invBased ? group.getDrawerInventory().getDrawerSlot(record.slot) : record.slot;
            if (!group.isDrawerEnabled(drawerSlot) || (drawer = group.getDrawer(drawerSlot)).isEmpty() || BitDrawers.cnb_api.getItemType(item = drawer.getStoredItemPrototype()) != ItemType.CHISLED_BIT) continue;
            try {
                List<TileEntityController.SlotRecord> slotRecords;
                IBitBrush brush = BitDrawers.cnb_api.createBrush(item);
                if (BitDrawers.config.debugTrace) {
                    BDLogger.info("Rebuilding: %s %d %d %d", item.func_82833_r(), record.slot, i, brush.getStateID());
                }
                if ((slotRecords = lookup.get(brush.getStateID())) == null) {
                    slotRecords = new ArrayList<TileEntityController.SlotRecord>();
                    lookup.put(brush.getStateID(), slotRecords);
                }
                slotRecords.add(record);
                continue;
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("Rebuilt: %d entries", lookup.size());
        }
    }

    protected IDrawer getAccessibleBitDrawer(TileEntityController.SlotRecord slotRecord, GameProfile profile) {
        if (slotRecord == null) {
            return null;
        }
        IDrawerGroup group = this.getGroupForSlotRecord(slotRecord);
        if (!(group instanceof IProtectable) || SecurityManager.hasAccess((GameProfile)profile, (IProtectable)((IProtectable)group))) {
            return group.getDrawer(slotRecord.slot);
        }
        return null;
    }

    public int fillBag(IBitBag bag, GameProfile profile) {
        Integer[] result = new Integer[]{0};
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitController.fillBag", new Object[0]);
        }
        this.drawerBitLookup.forEach((blockStateID, slotList) -> {
            try {
                ItemStack bit = BitDrawers.cnb_api.getBitItem(new BitBrush(blockStateID.intValue()).getState());
                int addSlot = -1;
                for (int i = 0; i < bag.getSlots(); ++i) {
                    ItemStack test = bag.getStackInSlot(i);
                    if (test == null) {
                        if (addSlot != -1) continue;
                        addSlot = i;
                        continue;
                    }
                    if (test.field_77994_a >= bag.getBitbagStackSize() || !BitHelper.areItemsEqual(test, bit)) continue;
                    addSlot = i;
                    break;
                }
                int doAddSlot = addSlot;
                if (addSlot > -1) {
                    slotList.stream().forEachOrdered(slotRecord -> {
                        IDrawer drawer = this.getAccessibleBitDrawer((TileEntityController.SlotRecord)slotRecord, profile);
                        if (drawer != null) {
                            result[0] = result[0] + this.fillBagSlot(bag, doAddSlot, drawer);
                        }
                    });
                }
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        });
        return result[0];
    }

    protected int fillBagSlot(IBitBag bag, int slot, IDrawer drawer) {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitController:fillBagSlot %d %s", slot, drawer.getStoredItemPrototype() == null ? "null" : drawer.getStoredItemPrototype().func_82833_r());
        }
        if (drawer.getStoredItemCount() == 0) {
            return 0;
        }
        int toAdd = bag.getBitbagStackSize();
        ItemStack item = bag.getStackInSlot(slot);
        if (item != null) {
            toAdd -= item.field_77994_a;
        }
        item = drawer.getStoredItemPrototype().func_77946_l();
        item.field_77994_a = toAdd;
        ItemStack test = bag.insertItem(slot, item.func_77946_l(), true);
        if (test != null) {
            toAdd -= test.field_77994_a;
        }
        if (toAdd == 0) {
            return 0;
        }
        toAdd = Math.min(toAdd, drawer.getStoredItemCount());
        drawer.setStoredItemCount(drawer.getStoredItemCount() - toAdd);
        item.field_77994_a = toAdd;
        test = bag.insertItem(slot, item, false);
        if (test != null && test.field_77994_a != 0) {
            BDLogger.error("Could not insert simulated bit amount into bag. Something went very wrong.", new Object[0]);
        }
        return toAdd;
    }

    public ItemStack retrieveByPattern(ItemStack pattern, EntityPlayer player, boolean getStack) {
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("TileBitController:retrieveByPattern", new Object[0]);
        }
        IBitAccess source = BitDrawers.cnb_api.createBitItem(pattern);
        GameProfile profile = player.func_146103_bH();
        if (source == null) {
            return null;
        }
        BitHelper.BitCounter counter = new BitHelper.BitCounter();
        source.visitBits((IBitVisitor)counter);
        if (BitDrawers.config.debugTrace) {
            BDLogger.info("Lookup size: %d", this.drawerBitLookup.size());
        }
        HashMap<Integer, Integer> available = new HashMap<Integer, Integer>();
        counter.counts.forEach((blockStateID, count) -> {
            if (BitDrawers.config.debugTrace) {
                BDLogger.info("Needed %d %d", blockStateID, count);
            }
            available.put((Integer)blockStateID, 0);
            List<TileEntityController.SlotRecord> records = this.drawerBitLookup.get(blockStateID);
            if (records == null) {
                return;
            }
            records.stream().forEachOrdered(slotRecord -> {
                IDrawer drawer;
                if (BitDrawers.config.debugTrace) {
                    BDLogger.info("  Trying %d", slotRecord.slot);
                }
                if ((drawer = this.getAccessibleBitDrawer((TileEntityController.SlotRecord)slotRecord, profile)) != null) {
                    if (BitDrawers.config.debugTrace) {
                        BDLogger.info("  Drawer found: %d", slotRecord.slot);
                    }
                    available.put((Integer)blockStateID, (Integer)available.get(blockStateID) + drawer.getStoredItemCount());
                }
            });
        });
        Integer[] max = new Integer[]{Integer.MAX_VALUE};
        available.forEach((blockStateID, count) -> {
            int m;
            if (BitDrawers.config.debugTrace) {
                BDLogger.info("Available %d %d", blockStateID, count);
            }
            if ((m = count / counter.counts.get(blockStateID)) == 0 && BitDrawers.config.chatty) {
                ItemStack desc = new BitBrush(blockStateID.intValue()).getItemStack(1);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.notEnough", new Object[]{desc == null ? "Unknown" : desc.func_82833_r()}));
            }
            max[0] = Math.min(max[0], m);
        });
        int toExtract = Math.min(max[0], getStack ? 64 : 1);
        if (toExtract == 0) {
            return null;
        }
        ItemStack stack = source.getBitsAsItem(ModUtil.getSide((ItemStack)pattern), ItemType.CHISLED_BLOCK, false);
        stack.field_77994_a = toExtract;
        Integer[] temp = new Integer[1];
        counter.counts.forEach((blockStateID, count) -> {
            temp[0] = count * toExtract;
            List<TileEntityController.SlotRecord> records = this.drawerBitLookup.get(blockStateID);
            if (records == null) {
                stack.field_77994_a = 0;
                return;
            }
            records.stream().forEachOrdered(slotRecord -> {
                IDrawer drawer = this.getAccessibleBitDrawer((TileEntityController.SlotRecord)slotRecord, profile);
                if (drawer != null) {
                    int ex = Math.min(temp[0], drawer.getStoredItemCount());
                    drawer.setStoredItemCount(drawer.getStoredItemCount() - ex);
                    temp[0] = temp[0] - ex;
                }
            });
            if (temp[0] > 0) {
                stack.field_77994_a = 0;
            }
        });
        if (stack.field_77994_a == 0) {
            BDLogger.error("Could not extract simulated bit for block. Something went very wrong.", new Object[0]);
            return null;
        }
        return stack;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.securityKey = null;
        if (tag.func_74764_b("Sec")) {
            this.securityKey = tag.func_74779_i("Sec");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.securityKey != null) {
            tag.func_74778_a("Sec", this.securityKey);
        }
        return tag;
    }

    public UUID getOwner() {
        return null;
    }

    public boolean setOwner(UUID uuid) {
        return false;
    }

    public ISecurityProvider getSecurityProvider() {
        return StorageDrawers.securityRegistry.getProvider(this.securityKey);
    }

    public ILockableContainer getLockableContainer() {
        return null;
    }

    public boolean setSecurityProvider(ISecurityProvider provider) {
        String newKey;
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        String string = newKey = provider == null ? null : provider.getProviderID();
        if (newKey != null && !newKey.equals(this.securityKey) || this.securityKey != null && !this.securityKey.equals(newKey)) {
            this.securityKey = newKey;
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
            }
        }
        return true;
    }

    protected static class BitCollectorData {
        protected final int count;
        protected final IBitBrush brush;
        protected final ItemStack stack;
        public int canStore = 0;
        public final List<IDrawer> drawers = new ArrayList<IDrawer>();
        public int canStoreItems = 0;
        public int toStore = 0;

        public BitCollectorData(int blockStateID, int count) throws APIExceptions.InvalidBitItem {
            this.count = count;
            this.brush = new BitBrush(blockStateID);
            this.stack = BitDrawers.cnb_api.getBitItem(this.brush.getState());
        }

        public void calc() {
            this.canStoreItems = this.canStore == -1 ? Integer.MAX_VALUE : this.canStore / this.count;
        }

        public int toStore(int items) {
            this.toStore = items * this.count;
            return this.toStore;
        }

        public void stored(int stored) {
            this.toStore -= stored;
        }

        public static List<BitCollectorData> collect(BitHelper.BitCounter counter) throws APIExceptions.InvalidBitItem {
            ArrayList<BitCollectorData> list = new ArrayList<BitCollectorData>();
            counter.counts.forEach((blockStateID, count) -> {
                try {
                    list.add(new BitCollectorData((int)blockStateID, (int)count));
                }
                catch (APIExceptions.InvalidBitItem invalidBitItem) {
                    // empty catch block
                }
            });
            if (list.size() != counter.counts.size()) {
                throw new APIExceptions.InvalidBitItem();
            }
            return list;
        }
    }
}

