/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.network.MultipartNetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageMultipartChange
implements IMessage,
IMessageHandler<MessageMultipartChange, MessageMultipartChange> {
    private Type type;
    private UUID partID;
    private ResourceLocation partType;
    private IMultipart part;
    private BlockPos pos;
    private byte[] data;

    private MessageMultipartChange(Type type, UUID partID, ResourceLocation partType, IMultipart part, BlockPos pos) {
        this.type = type;
        this.partID = partID;
        this.partType = partType;
        this.part = part;
        this.pos = pos;
    }

    public MessageMultipartChange() {
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeLong(this.partID.getMostSignificantBits());
        buf.writeLong(this.partID.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.part.getType().toString());
        buf.writeInt(this.pos.func_177958_n()).writeInt(this.pos.func_177956_o()).writeInt(this.pos.func_177952_p());
        if (this.type == Type.ADD || this.type == Type.UPDATE || this.type == Type.UPDATE_RERENDER) {
            ByteBuf dataBuf = Unpooled.buffer();
            this.part.writeUpdatePacket(new PacketBuffer(dataBuf));
            this.data = dataBuf.array();
            dataBuf.clear();
            buf.writeMedium(this.data.length);
            buf.writeBytes(this.data);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.VALUES[buf.readInt()];
        long msb = buf.readLong();
        long lsb = buf.readLong();
        this.partID = new UUID(msb, lsb);
        this.partType = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        if (this.type == Type.ADD || this.type == Type.UPDATE || this.type == Type.UPDATE_RERENDER) {
            this.data = new byte[buf.readUnsignedMedium()];
            buf.readBytes(this.data, 0, this.data.length);
        }
    }

    public MessageMultipartChange onMessage(MessageMultipartChange message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.schedulePacketHandling(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void schedulePacketHandling(final MessageMultipartChange message) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                MessageMultipartChange.handlePacket(message);
            }
        });
    }

    private static void handlePacket(MessageMultipartChange message) {
        EntityPlayer player = MCMultiPartMod.proxy.getPlayer();
        if (player == null || message.pos == null || message.type == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        if (message.type == Type.ADD) {
            message.part = MultipartRegistry.createPart(message.partType, new PacketBuffer(Unpooled.copiedBuffer((byte[])message.data)));
            MultipartHelper.addPart(world, message.pos, message.part, message.partID);
            if (message.part.getModelPath() != null) {
                world.func_175704_b(message.pos, message.pos);
            }
            world.func_175664_x(message.pos);
        } else if (message.type == Type.REMOVE) {
            IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, message.pos);
            if (container != null) {
                message.part = container.getPartFromID(message.partID);
                if (message.part != null) {
                    container.removePart(message.part);
                    if (message.part.getModelPath() != null) {
                        world.func_175704_b(message.pos, message.pos);
                    }
                }
                world.func_175664_x(message.pos);
            }
        } else if (message.type == Type.UPDATE || message.type == Type.UPDATE_RERENDER) {
            IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, message.pos);
            if (container == null) {
                return;
            }
            message.part = container.getPartFromID(message.partID);
            if (message.part != null) {
                message.part.readUpdatePacket(new PacketBuffer(Unpooled.copiedBuffer((byte[])message.data)));
                if (message.type == Type.UPDATE_RERENDER) {
                    world.func_175704_b(message.pos, message.pos);
                }
            }
        }
    }

    public void send(World world) {
        MultipartNetworkHandler.sendToAllWatching(this, world, this.pos);
    }

    public static MessageMultipartChange newPacket(World world, BlockPos pos, IMultipart part, Type type) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, pos);
        if (container == null) {
            throw new IllegalStateException("Attempted to " + type.name().toLowerCase() + " a multipart at an illegal position!");
        }
        return new MessageMultipartChange(type, container.getPartID(part), part.getType(), part, pos);
    }

    public static enum Type {
        ADD,
        REMOVE,
        UPDATE,
        UPDATE_RERENDER;

        public static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

