/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.misc;

import com.google.common.base.Strings;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.SPConfig;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.common.block.BlockVault;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public SPConfig config;
    private ArrayList<Pair<String[], BlockVault.EnumType>> listPair = new ArrayList();
    private ArrayList<Triple<String[], ArrayList<ItemStack>, ItemStack>> listTriple = new ArrayList();

    void setupConfig(File file) {
        this.config = new SPConfig(file);
        this.config.load();
        this.syncConfig();
    }

    public void syncConfig() {
        Settings settings = Settings.INSTANCE;
        Settings.Setup setup = settings.setupDone() ? Settings.INSTANCE.new Settings.Setup() : Settings.INSTANCE.setup();
        this.config.addCustomCategoryComment("BLOCKS", "Controls what blocks are added by MultiStorage");
        this.config.setCategoryRequiresWorldRestart("BLOCKS", true);
        this.config.setCategoryRequiresMcRestart("BLOCKS", true);
        setup.addVaultBlocks = this.config.getBoolean("addVaultBlocks", "BLOCKS", true, "All Vault Blocks");
        setup.addStorageBlocks = this.config.getBoolean("addStorageBlocks", "BLOCKS", true, "Stackable Chests, and Hidden Chests");
        setup.addEnderLinkChests = this.config.getBoolean("addEnderLinkChests", "BLOCKS", true, "EnderLinked Chests");
        this.config.addCustomCategoryComment("ITEMS", "Controls what items are added by MultiStorage");
        this.config.setCategoryRequiresWorldRestart("ITEMS", true);
        this.config.setCategoryRequiresMcRestart("ITEMS", true);
        settings.enableEnderBag = this.config.getBoolean("enableEnderBag", "ITEMS", true, "A bag that accesses a players EnderChest");
        settings.enableEnderLinkBag = this.config.getBoolean("enableEnderLinkBag", "ITEMS", true, "EnderLinked Bags");
        setup.addEnderBags = settings.enableEnderBag || settings.enableEnderLinkBag || setup.addEnderLinkChests;
        this.config.addCustomCategoryComment("SETTINGS-ENDERPOCKET", " ");
        this.config.setCategoryRequiresWorldRestart("SETTINGS-ENDERPOCKET", false);
        this.config.setCategoryRequiresMcRestart("SETTINGS-ENDERPOCKET", false);
        settings.enableEnderPocket = this.config.getBoolean("enableEnderPocket", "SETTINGS-ENDERPOCKET", false, "Adds a button to the player inventory enabling access their Ender Chest");
        int posXi = this.config.getInt("pocketX-Inventory", "SETTINGS-ENDERPOCKET", -2, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
        int posYi = this.config.getInt("pocketY-Inventory", "SETTINGS-ENDERPOCKET", 24, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
        int posXc = this.config.getInt("pocketX-Creative", "SETTINGS-ENDERPOCKET", 50, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
        int posYc = this.config.getInt("pocketY-Creative", "SETTINGS-ENDERPOCKET", 52, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
        settings.offsetEnderPocket = new Point[]{new Point(posXi, posYi), new Point(posXc, posYc)};
        this.config.addCustomCategoryComment("SETTINGS-VAULT", " ");
        this.config.setCategoryRequiresWorldRestart("SETTINGS-VAULT", false);
        this.config.setCategoryRequiresMcRestart("SETTINGS-VAULT", false);
        settings.permissionVault = (byte)this.config.getInt("createVault", "SETTINGS-VAULT", 3, 0, 3, "Sets who has permission to place a Vault Door.\n0 = No One, 1 = OP's Only, 2 = OP's and Creative Players, 3 = Everyone\nNOTE: Does not disable/remove existing Vaults");
        settings.pickupVaultBlocks = (byte)this.config.getInt("pickupVaultBlocks", "SETTINGS-VAULT", 1, 0, 2, "Sets if Vault Blocks can be picked up.\n0 = Never, 1 = With SilkTouch, 2 = Always");
        setup.craftableVaultBlocks = (byte)this.config.getInt("craftableVaultBlocks", "SETTINGS-VAULT", 0, 0, 16, "Adds Vault Block crafting recipes\n0 = Only doors and concrete are craftable, everything else must be poured in world\n1+ = All blocks have recipes, the result quantity equals [given value] for normal walls, and 1 for special walls");
        String[] wallItems_Base = this.config.getStringList("wallItems_Base", "SETTINGS-VAULT", new String[]{"minecraft:iron_bars"}, "These items are used to make normal vault walls\n");
        String[] wallItems_Item = this.config.getStringList("wallItems_Item", "SETTINGS-VAULT", new String[]{"minecraft:hopper"}, "These items are used to make item pass vault walls\n");
        String[] wallItems_Redstone = this.config.getStringList("wallItems_Redstone", "SETTINGS-VAULT", new String[]{"ore:blockRedstone"}, "These items are used to make redstone pass vault walls\n");
        String[] wallItems_Fluid = this.config.getStringList("wallItems_Fluid", "SETTINGS-VAULT", new String[]{"ore:blockGlass"}, "These items are used to make fluid pass vault walls\n");
        String[] wallItems_EU = this.config.getStringList("wallItems_EU", "SETTINGS-VAULT", new String[]{"ic2:cable@1"}, "These items are used to make EU power pass vault walls\n");
        String[] wallItems_RF = new String[]{"BuildCraft|Transport:item.buildcraftPipe.pipepowerdiamond", "immersiveengineering:connector@5"};
        wallItems_RF = this.config.getStringList("wallItems_RF", "SETTINGS-VAULT", wallItems_RF, "These items are used to make RF power pass vault walls\n");
        String[] wallItems_Caps = new String[]{"enderio:itemPowerConduit@2", "teslacoils:blockRelayCoil"};
        wallItems_Caps = this.config.getStringList("wallItems_Caps", "SETTINGS-VAULT", wallItems_Caps, "These items are used to make Forge or Tesla power pass vault walls\n");
        this.config.moveProperty("SETTINGS-VAULT", "logFileSize", "SETTINGS-VAULT-LOGS");
        this.config.addCustomCategoryComment("SETTINGS-VAULT-LOGS", " ");
        this.config.setCategoryRequiresWorldRestart("SETTINGS-VAULT-LOGS", false);
        this.config.setCategoryRequiresMcRestart("SETTINGS-VAULT-LOGS", false);
        settings.logFileSize = (short)this.config.getInt("logFileSize", "SETTINGS-VAULT-LOGS", 63, -1, Short.MAX_VALUE, "Sets the size, in Kilobytes, a log file can be before it gets split.\n'-1' disables log files completely, '0' disables splitting\nNote: The default is 63 because notepad has trouble opening files that are 64k or larger");
        settings.logEntry = this.config.getBoolean("logEntry", "SETTINGS-VAULT-LOGS", true, "Log when a player enters a vault");
        settings.logExit = this.config.getBoolean("logExit", "SETTINGS-VAULT-LOGS", true, "Log when a player leaves a vault");
        settings.logAdded = this.config.getBoolean("logAdded", "SETTINGS-VAULT-LOGS", true, "Log when a player added to the access list");
        settings.logRemoved = this.config.getBoolean("logRemoved", "SETTINGS-VAULT-LOGS", true, "Log when a player removed from the access list");
        settings.logPromoted = this.config.getBoolean("logPromoted", "SETTINGS-VAULT-LOGS", true, "Log when a player is promoted to a vault admin");
        settings.logDemoted = this.config.getBoolean("logDemoted", "SETTINGS-VAULT-LOGS", true, "Log when a player is demoted from a vault admin");
        this.config.addCustomCategoryComment("SETTINGS-ENDERLINK", " ");
        this.config.setCategoryRequiresWorldRestart("SETTINGS-ENDERLINK", false);
        this.config.setCategoryRequiresMcRestart("SETTINGS-ENDERLINK", false);
        String[] personalItems = this.config.getStringList("Personal", "SETTINGS-ENDERLINK", new String[]{"ore:gemDiamond"}, "Items Listed are used to make the EnderLinkChest's personal\n");
        String[] sCapacityItems = this.config.getStringList("SmallCapacity", "SETTINGS-ENDERLINK", new String[]{"ore:enderpearl"}, "Items Listed upgrade the EnderLinkChest's storage capacity by 3\n");
        String[] lCapacityItems = this.config.getStringList("LargeCapacity", "SETTINGS-ENDERLINK", new String[]{"minecraft:ender_eye"}, "Items Listed upgrade the EnderLinkChest's storage capacity by 9\n");
        settings.chestSizeMin = (byte)this.config.getInt("CapacityMin", "SETTINGS-ENDERLINK", 9, 9, 27, "Minimum capacity an EnderLinkChest. Note: value will be rounded to a power of 3\n");
        settings.chestSizeMax = (byte)this.config.getInt("CapacityMax", "SETTINGS-ENDERLINK", 27, 9, 54, "Maximum capacity an EnderLinkChest. Note: value will be rounded to a power of 3\n");
        settings.chestSizeMin = (byte)(settings.chestSizeMin / 3 * 3);
        settings.chestSizeMax = (byte)(settings.chestSizeMax / 3 * 3);
        if (settings.chestSizeMax < settings.chestSizeMin) {
            settings.chestSizeMax = settings.chestSizeMin;
        }
        this.config.addCustomCategoryComment("COLOR-VALUES", "Color Values for Bands,\nFormat: Decimal Values (0 to 16,777,215)\nYou can use this website to get the decimal value of any color:\nhttp://www.colorhexa.com\nOr by using the Color Mixer from this website:\nhttp://www.mathsisfun.com/hexadecimal-decimal-colors.html\n");
        this.config.setCategoryRequiresWorldRestart("COLOR-VALUES", false);
        this.config.setCategoryRequiresMcRestart("COLOR-VALUES", false);
        String[] colorNames = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
        for (int scan = 0; scan < colorNames.length; scan = (int)((byte)(scan + 1))) {
            settings.colorValues[scan] = this.config.getInt(colorNames[scan], "COLOR-VALUES", settings.colorValues[scan], 0, 0xFFFFFF, "");
        }
        this.listPair.clear();
        this.listPair.add((Pair<String[], BlockVault.EnumType>)Pair.of((Object)wallItems_Base, (Object)((Object)BlockVault.EnumType.WALL_NORMAL)));
        this.listPair.add((Pair<String[], BlockVault.EnumType>)Pair.of((Object)wallItems_Item, (Object)((Object)BlockVault.EnumType.WALL_ITEM)));
        this.listPair.add((Pair<String[], BlockVault.EnumType>)Pair.of((Object)wallItems_Redstone, (Object)((Object)BlockVault.EnumType.WALL_REDSTONE)));
        this.listPair.add((Pair<String[], BlockVault.EnumType>)Pair.of((Object)wallItems_Fluid, (Object)((Object)BlockVault.EnumType.WALL_FLUID)));
        this.listPair.add((Pair<String[], BlockVault.EnumType>)Pair.of((Object)wallItems_EU, (Object)((Object)BlockVault.EnumType.WALL_POWER_EU)));
        this.listPair.add((Pair<String[], BlockVault.EnumType>)Pair.of((Object)wallItems_RF, (Object)((Object)BlockVault.EnumType.WALL_POWER_RF)));
        this.listPair.add((Pair<String[], BlockVault.EnumType>)Pair.of((Object)wallItems_Caps, (Object)((Object)BlockVault.EnumType.WALL_POWER_CAPS)));
        this.listTriple.clear();
        this.listTriple.add((Triple<String[], ArrayList<ItemStack>, ItemStack>)Triple.of((Object)personalItems, settings.itemPersonal, (Object)new ItemStack(Items.field_151045_i)));
        this.listTriple.add((Triple<String[], ArrayList<ItemStack>, ItemStack>)Triple.of((Object)sCapacityItems, settings.itemSCapacityUpgrade, (Object)new ItemStack(Items.field_151079_bi)));
        this.listTriple.add((Triple<String[], ArrayList<ItemStack>, ItemStack>)Triple.of((Object)lCapacityItems, settings.itemLCapacityUpgrade, (Object)new ItemStack(Items.field_151061_bv)));
        if (this.config.hasChanged()) {
            this.config.save();
            if (settings.setupDone()) {
                this.processLists();
            }
        }
    }

    public void processLists() {
        for (Pair<String[], BlockVault.EnumType> pair : this.listPair) {
            this.process((String[])pair.getLeft(), (BlockVault.EnumType)((Object)pair.getRight()));
        }
        this.listPair.clear();
        for (Triple triple : this.listTriple) {
            this.process((String[])triple.getLeft(), (ArrayList)triple.getMiddle(), (ItemStack)triple.getRight());
        }
        this.listTriple.clear();
    }

    private void process(String[] names, BlockVault.EnumType type) {
        ArrayList<Object> typeList = new ArrayList<Object>();
        for (String name : names) {
            Object object = this.getItem(name);
            if (object instanceof String) {
                List ores = OreDictionary.getOres((String)((String)object));
                if (ores.isEmpty()) continue;
                typeList.add(object);
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            typeList.add(object);
        }
        if (typeList.isEmpty() && type.getDefaultItem() != null) {
            typeList.add(type.getDefaultItem());
        }
        if (!typeList.isEmpty()) {
            Settings.INSTANCE.wallBaseItems.put(type, typeList);
        }
    }

    private void process(String[] names, ArrayList<ItemStack> list, ItemStack basic) {
        list.clear();
        for (String name : names) {
            Object object = this.getItem(name);
            if (object instanceof String) {
                List ores = OreDictionary.getOres((String)((String)object));
                for (ItemStack ore : ores) {
                    this.addToList(ore, list);
                }
                continue;
            }
            if (!(object instanceof ItemStack)) continue;
            this.addToList((ItemStack)object, list);
        }
        if (list.isEmpty()) {
            list.add(basic);
        }
    }

    private Object getItem(String name) {
        if (!Strings.isNullOrEmpty((String)name)) {
            Item item;
            String nameId;
            String modId = name.contains(":") ? name.split(":")[0] : "minecraft";
            String string = nameId = name.contains(":") ? name.split(":")[1] : name;
            if (modId.equalsIgnoreCase("ore") || modId.equalsIgnoreCase("oredictionary")) {
                return nameId;
            }
            int meta = Short.MAX_VALUE;
            if (nameId.contains("@")) {
                try {
                    meta = Integer.valueOf(nameId.split("@")[1]);
                    nameId = nameId.substring(0, nameId.lastIndexOf(64));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((item = GameRegistry.findItem((String)modId, (String)nameId)) != null) {
                return new ItemStack(item, 1, meta);
            }
            Block block = GameRegistry.findBlock((String)modId, (String)nameId);
            if (block != null && block != Blocks.field_150350_a) {
                return new ItemStack(block, 1, meta);
            }
        }
        return null;
    }

    private void addToList(ItemStack stack, ArrayList<ItemStack> list) {
        if (stack == null || list == null) {
            return;
        }
        if (list.contains(stack)) {
            return;
        }
        list.add(stack);
    }
}

