/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;
import shetiphian.multistorage.common.tileentity.TileEntityStackingChest;
import shetiphian.multistorage.modintegration.terraqueous.Terraqueous_Base;

public class ItemBlockStorageType
extends ItemBlockMulti {
    public ItemBlockStorageType(Block block) {
        super(block, "Block" + (block.func_149739_a().toLowerCase().contains("cloud") ? "Cloud" : "Stone") + "Storage", Values.nameMapper);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int meta = 0; meta < 7; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        int damage = stack.func_77952_i();
        return damage == 0 || this.canStackChests(damage, world, pos, side) || super.func_179222_a(world, pos, side, player, stack);
    }

    private boolean canStackChests(int damage, World world, BlockPos pos, EnumFacing side) {
        TileEntityJunkbox junkbox;
        if (damage != 5 || side != EnumFacing.DOWN && side != EnumFacing.UP || world.func_180495_p(pos).func_177230_c() != this.func_179223_d()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityJunkbox && !(junkbox = (TileEntityJunkbox)tile).isDouble()) {
            return side == EnumFacing.DOWN && junkbox.isTop() || side == EnumFacing.UP && !junkbox.isTop();
        }
        return false;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (stack.field_77994_a == 0) {
            return EnumActionResult.PASS;
        }
        int damage = stack.func_77952_i();
        if (damage == 0) {
            BlockStorageType.EnumType type;
            IBlockState state;
            if (player.func_175151_a(pos, facing, stack) && Terraqueous_Base.INSTANCE.canPlaceAt(world, pos, this.nameId.toLowerCase().contains("cloud")) && (state = world.func_180495_p(pos)).func_177230_c() == this.func_179223_d() && !(type = BlockStorageType.getEnumType(state)).isDense()) {
                NBTTagCompound nbtTag = world.func_175625_s(pos).serializeNBT();
                state = state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)BlockStorageType.EnumType.byValue(type.getValue() + 8)));
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true);
                world.func_175625_s(pos).deserializeNBT(nbtTag);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                SoundType soundtype = this.field_150939_a.func_185467_w();
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        if (this.canStackChests(damage, world, pos, facing)) {
            TileEntityJunkbox tile = (TileEntityJunkbox)world.func_175625_s(pos);
            tile.setDouble();
            Function.syncTile((TileEntity)tile);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            SoundType soundtype = this.field_150939_a.func_185467_w();
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return EnumActionResult.SUCCESS;
        }
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!player.func_175151_a(pos, facing, stack) || !Terraqueous_Base.INSTANCE.canPlaceAt(world, pos, this.nameId.toLowerCase().contains("cloud"))) {
            return EnumActionResult.FAIL;
        }
        BlockStorageType.EnumType type = null;
        switch (damage) {
            case 1: {
                type = BlockStorageType.EnumType.STACKABLE_SINGLE;
                break;
            }
            case 2: {
                type = BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE;
                break;
            }
            case 3: {
                type = BlockStorageType.EnumType.CHAMELEON;
                break;
            }
            case 4: {
                type = BlockStorageType.EnumType.DENSE_CHAMELEON;
                break;
            }
            case 5: {
                type = BlockStorageType.EnumType.JUNKBOX_BOTTOM;
                break;
            }
            case 6: {
                type = BlockStorageType.EnumType.DENSE_JUNKBOX_BOTTOM;
            }
        }
        if (type == null) {
            return EnumActionResult.FAIL;
        }
        if (!Function.setBlock((World)world, (BlockPos)pos, (IBlockState)this.field_150939_a.func_176223_P().func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)type)), (boolean)false)) {
            return EnumActionResult.FAIL;
        }
        SoundType soundtype = this.field_150939_a.func_185467_w();
        world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityStackingChest) {
            BlockStorageType.STACKING.onBlockPlaced(stack, player, world, pos, facing, hitX, hitY, hitZ);
        } else if (tile instanceof TileEntityChameleon) {
            BlockStorageType.CHAMELEON.onBlockPlaced(stack, player, world, pos, facing, hitX, hitY, hitZ);
            ((TileEntityChameleon)tile).setClonedPos(pos.func_177972_a(facing.func_176734_d()));
        } else if (tile instanceof TileEntityJunkbox) {
            BlockStorageType.JUNKBOX.onBlockPlaced(stack, player, world, pos, facing, hitX, hitY, hitZ);
        } else {
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)false);
            return EnumActionResult.FAIL;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        return EnumActionResult.SUCCESS;
    }

    protected void addToNameMap() {
        String type = this.nameId.toLowerCase().contains("cloud") ? "cloud" : "stone";
        this.add(0, "", type + "_upgrade", "upgrade");
        this.add(1, "", type + "_stacking", "stacking");
        this.add(2, "", type + "_stacking_dense", "stacking.dense");
        this.add(3, "", type + "_chameleon", "chameleon");
        this.add(4, "", type + "_chameleon_dense", "chameleon.dense");
        this.add(5, "", type + "_junkbox", "junkbox");
        this.add(6, "", type + "_junkbox_dense", "junkbox.dense");
    }
}

