/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.block;

import java.util.List;
import java.util.Set;
import mod.flatcoloredblocks.FlatColoredBlocks;
import mod.flatcoloredblocks.block.BlockFlatColored;
import mod.flatcoloredblocks.block.ConversionHSV2RGB;
import mod.flatcoloredblocks.block.EnumFlatColorAttributes;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class ItemBlockFlatColored
extends ItemBlock {
    public BlockFlatColored getColoredBlock() {
        return (BlockFlatColored)this.field_150939_a;
    }

    private IBlockState getStateFromStack(ItemStack stack) {
        return this.func_179223_d().func_176203_a(stack.func_77952_i());
    }

    private String getColorPrefix(Set<EnumFlatColorAttributes> which) {
        if (which.contains((Object)EnumFlatColorAttributes.dark)) {
            return "flatcoloredblocks.dark";
        }
        if (which.contains((Object)EnumFlatColorAttributes.light)) {
            return "flatcoloredblocks.light";
        }
        return "flatcoloredblocks.";
    }

    private String getColorHueName(Set<EnumFlatColorAttributes> characteristics) {
        for (EnumFlatColorAttributes c : characteristics) {
            if (c.isModifier) continue;
            return c.name();
        }
        return EnumFlatColorAttributes.black.name();
    }

    public ItemBlockFlatColored(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77653_i(ItemStack stack) {
        IBlockState state = this.getStateFromStack(stack);
        int shadeNum = this.getColoredBlock().getShadeNumber(state);
        Set<EnumFlatColorAttributes> colorChars = this.getColoredBlock().getFlatColorAttributes(state);
        String type = this.getTypeLocalization();
        String prefix = this.getColorPrefix(colorChars);
        String hue = this.getColorHueName(colorChars);
        return type + I18n.func_74838_a((String)(prefix + hue + ".name")) + " #" + shadeNum;
    }

    private String getTypeLocalization() {
        switch (this.getColoredBlock().getType()) {
            case GLOWING: {
                return I18n.func_74838_a((String)"flatcoloredblocks.Glowing.name") + " ";
            }
            case TRANSPARENT: {
                return I18n.func_74838_a((String)"flatcoloredblocks.Transparent.name") + " ";
            }
        }
        return "";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        StringBuilder sb;
        IBlockState state = this.getStateFromStack(stack);
        BlockFlatColored blk = this.getColoredBlock();
        int hsv = blk.hsvFromState(state);
        int rgb = ConversionHSV2RGB.toRGB(hsv);
        if (FlatColoredBlocks.instance.config.showRGB) {
            this.addColor(true, rgb, tooltip);
        }
        if (FlatColoredBlocks.instance.config.showHSV) {
            this.addColor(false, hsv, tooltip);
        }
        if (FlatColoredBlocks.instance.config.showLight && blk.field_149784_t > 0) {
            sb = new StringBuilder();
            sb.append(I18n.func_74838_a((String)"flatcoloredblocks.tooltips.lightvalue")).append(' ');
            sb.append(blk.field_149784_t).append("/15");
            tooltip.add(sb.toString());
        }
        if (FlatColoredBlocks.instance.config.showOpacity && blk.opacity < 100) {
            sb = new StringBuilder();
            sb.append(I18n.func_74838_a((String)"flatcoloredblocks.tooltips.opacity")).append(' ');
            sb.append(blk.opacity).append('%');
            tooltip.add(sb.toString());
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    private void addColor(boolean isRgb, int value, List<String> tooltip) {
        int r_h = value >> 16 & 0xFF;
        int g_s = value >> 8 & 0xFF;
        int b_v = value & 0xFF;
        StringBuilder sb = new StringBuilder();
        if (isRgb) {
            sb.append(I18n.func_74838_a((String)"flatcoloredblocks.tooltips.rgb")).append(' ');
            sb.append(TextFormatting.RED).append(r_h).append(' ');
            sb.append(TextFormatting.GREEN).append(g_s).append(' ');
            sb.append(TextFormatting.BLUE).append(b_v);
        } else {
            sb.append(I18n.func_74838_a((String)"flatcoloredblocks.tooltips.hsv")).append(' ');
            sb.append(360 * r_h / 255).append("\u00ef\u00bf\u00bd ");
            sb.append(100 * g_s / 255).append("% ");
            sb.append(100 * b_v / 255).append('%');
        }
        tooltip.add(sb.toString());
    }

    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        IBlockState state = this.getStateFromStack(stack);
        return this.getColoredBlock().colorFromState(state);
    }
}

