/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.pages;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;
import techreborn.manual.PageCollection;
import techreborn.manual.pages.TitledPage;
import techreborn.manual.util.ButtonUtil;

public class CraftingInfoPage
extends TitledPage {
    public ItemStack result;
    public String imageprefix = "techreborn:textures/manual/elements/";
    public String backpage;
    private boolean isSmelting = false;
    private ItemStack[] recipe = new ItemStack[9];
    private boolean hasRecipe = false;
    private String rawDescription;
    private List<String> formattedDescription;
    private float descriptionScale = 0.66f;

    public CraftingInfoPage(String name, PageCollection collection, ItemStack itemStack, String unlocalizedDescription, String backPage) {
        super(name, true, collection, itemStack.func_77977_a() + ".name", Color.white.getRGB());
        this.result = itemStack;
        this.recipe = this.getFirstRecipeForItem(itemStack);
        this.backpage = backPage;
        for (ItemStack stack : this.recipe) {
            if (stack == null) continue;
            this.hasRecipe = true;
        }
        this.rawDescription = unlocalizedDescription == "" ? this.ttl(itemStack.func_77977_a() + ".description") : this.ttl(unlocalizedDescription);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        ButtonUtil.addBackButton(0, this.field_146294_l / 2 - 60, this.field_146295_m / 2 + 64, this.field_146292_n);
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderBackgroundLayer(minecraft, offsetX, offsetY, mouseX, mouseY);
        GL11.glPushMatrix();
        if (this.isSmelting) {
            this.renderImage(offsetX + 15, offsetY + 10, "furnacerecipe");
        } else if (this.hasRecipe) {
            this.renderImage(offsetX + offsetX / 2, offsetY + 10, "craftingtable");
        } else {
            this.func_73731_b(this.field_146289_q, "No Crafting Recipe", offsetX + 40, offsetY + 22, Color.black.getRGB());
        }
        GL11.glPopMatrix();
    }

    @Override
    public void drawScreen(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawScreen(minecraft, offsetX, offsetY, mouseX, mouseY);
        int relativeMouseX = mouseX + offsetX;
        int relativeMouseY = mouseY + offsetY;
        int gridOffsetX = this.isSmelting ? 85 : 71;
        int gridOffsetY = 18;
        int itemBoxSize = 18;
        this.addDescription(minecraft, offsetX + 8, offsetY);
        ItemStack tooltip = null;
        int i = 0;
        for (ItemStack input : this.recipe) {
            if (input != null) {
                int row = i % 3;
                int column = i / 3;
                int itemX = offsetX + gridOffsetX + row * itemBoxSize - 54;
                int itemY = offsetY + gridOffsetY + column * itemBoxSize + 2;
                this.drawItemStack(input, itemX, itemY, "");
                if (relativeMouseX > itemX - 2 && relativeMouseX < itemX - 2 + itemBoxSize && relativeMouseY > itemY - 2 && relativeMouseY < itemY - 2 + itemBoxSize) {
                    tooltip = input;
                }
            }
            ++i;
        }
        int itemX = offsetX + (this.isSmelting ? 92 : 112);
        int itemY = offsetY + (this.isSmelting ? 40 : 38);
        if (!this.hasRecipe) {
            itemX = offsetX + 20;
            itemY = offsetY + 18;
        }
        this.drawItemStack(this.result, itemX, itemY, "");
        if (relativeMouseX > itemX - 2 && relativeMouseX < itemX - 2 + itemBoxSize && relativeMouseY > itemY - 2 && relativeMouseY < itemY - 2 + itemBoxSize) {
            tooltip = this.result;
        }
        if (tooltip != null) {
            this.drawItemStackTooltip(tooltip, relativeMouseX, relativeMouseY);
        }
    }

    public void renderImage(int offsetX, int offsetY, String imagename) {
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(new ResourceLocation(this.imageprefix + imagename + ".png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(offsetX + 16, offsetY + 9, 0, 0, 116, 54);
        GL11.glDisable((int)3042);
    }

    public void addDescription(Minecraft minecraft, int offsetX, int offsetY) {
        GL11.glPushMatrix();
        if (this.hasRecipe) {
            GL11.glTranslated((double)(offsetX + 5), (double)(offsetY + 75), (double)1.0);
        } else {
            GL11.glTranslated((double)(offsetX + 5), (double)(offsetY + 40), (double)1.0);
        }
        GL11.glScalef((float)this.descriptionScale, (float)this.descriptionScale, (float)this.descriptionScale);
        int offset = 0;
        for (String s : this.getFormattedText(this.field_146289_q)) {
            if (s == null) break;
            if (s.contains("\\%") && s.substring(0, 2).equals("\\%")) {
                s = s.substring(2);
                offset += this.field_146289_q.field_78288_b / 2;
            }
            this.field_146289_q.func_78276_b(s, 0, offset, Color.black.getRGB());
            offset += this.field_146289_q.field_78288_b;
        }
        GL11.glPopMatrix();
    }

    public List<String> getFormattedText(FontRenderer fr) {
        if (this.formattedDescription == null) {
            this.formattedDescription = new ArrayList<String>();
            if (Strings.isNullOrEmpty((String)this.rawDescription)) {
                this.formattedDescription = ImmutableList.of();
                return this.formattedDescription;
            }
            if (!this.rawDescription.contains("\\n")) {
                this.formattedDescription = ImmutableList.copyOf((Collection)fr.func_78271_c(this.rawDescription, 370));
                return this.formattedDescription;
            }
            ArrayList<String> segments = new ArrayList<String>();
            String raw = this.rawDescription;
            int escape = 0;
            while (raw.contains("\\n")) {
                segments.add(raw.substring(0, raw.indexOf("\\n")));
                raw = raw.substring(raw.indexOf("\\n") + 2);
                if (!raw.contains("\\n")) {
                    segments.add(raw);
                }
                if (++escape <= 100) continue;
            }
            for (String s : segments) {
                this.formattedDescription.addAll((Collection<String>)ImmutableList.copyOf((Collection)fr.func_78271_c(s, 370)));
            }
        }
        return this.formattedDescription;
    }

    protected void drawItemStackTooltip(ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = (FontRenderer)Objects.firstNonNull((Object)stack.func_77973_b().getFontRenderer(stack), (Object)mc.field_71466_p);
        List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        ArrayList colored = Lists.newArrayListWithCapacity((int)list.size());
        colored.add(stack.func_77953_t().field_77937_e + (String)list.get(0));
        for (String line : list) {
            colored.add(TextFormatting.GRAY + line);
        }
        if (colored.size() >= 2) {
            colored.remove(1);
        }
        this.drawHoveringText(colored, x, y, font);
    }

    private void drawItemStack(ItemStack par1ItemStack, int par2, int par3, String par4Str) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        RenderHelper.func_74520_c();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2977);
        FontRenderer font = null;
        if (par1ItemStack != null) {
            font = par1ItemStack.func_77973_b().getFontRenderer(par1ItemStack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        this.renderItemStack(par1ItemStack, par2, par3);
        this.field_73735_i = 0.0f;
    }

    public void renderItemStack(ItemStack stack, int x, int y) {
        if (stack != null) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            RenderHelper.func_74520_c();
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            itemRenderer.func_180450_b(stack, x, y);
            GL11.glDisable((int)2896);
        }
    }

    private ItemStack[] getFirstRecipeForItem(ItemStack resultingItem) {
        ItemStack[] recipeItems = new ItemStack[9];
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            Object[] input;
            ItemStack result;
            if (recipe == null || (result = recipe.func_77571_b()) == null || !result.func_77969_a(resultingItem) || (input = this.getRecipeInput(recipe)) == null) continue;
            for (int i = 0; i < input.length; ++i) {
                recipeItems[i] = this.convertToStack(input[i]);
            }
        }
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (!(entry.getKey() instanceof ItemStack) || !((ItemStack)entry.getValue()).func_77969_a(this.result)) continue;
            this.isSmelting = true;
            recipeItems[0] = (ItemStack)entry.getKey();
        }
        return recipeItems;
    }

    protected ItemStack convertToStack(Object obj) {
        List list;
        ItemStack entry = null;
        if (obj instanceof ItemStack) {
            entry = (ItemStack)obj;
        } else if (obj instanceof List && (list = (List)obj).size() > 0) {
            entry = (ItemStack)list.get(0);
        }
        if (entry == null) {
            return null;
        }
        if ((entry = entry.func_77946_l()).func_77952_i() == Short.MAX_VALUE) {
            entry.func_77964_b(0);
        }
        return entry;
    }

    private Object[] getRecipeInput(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return ((ShapelessOreRecipe)recipe).getInput().toArray();
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getShapedOreRecipe((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77574_d;
        }
        if (recipe instanceof ShapelessRecipes) {
            return ((ShapelessRecipes)recipe).field_77579_b.toArray(new ItemStack[0]);
        }
        return null;
    }

    private Object[] getShapedOreRecipe(ShapedOreRecipe recipe) {
        try {
            Field field = ShapedOreRecipe.class.getDeclaredField("width");
            if (field != null) {
                field.setAccessible(true);
                int width = field.getInt(recipe);
                Object[] input = recipe.getInput();
                Object[] grid = new Object[9];
                int i = 0;
                int offset = 0;
                for (int y = 0; y < 3; ++y) {
                    int x = 0;
                    while (x < 3) {
                        if (x < width && offset < input.length) {
                            grid[i] = input[offset];
                            ++offset;
                        } else {
                            grid[i] = null;
                        }
                        ++x;
                        ++i;
                    }
                }
                return grid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.collection.changeActivePage(this.backpage);
        }
    }
}

