/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.minetweaker;

import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.util.ItemUtils;
import techreborn.api.recipe.BaseRecipe;

public class MTGeneric {
    public static String getMachineName() {
        return null;
    }

    public static void addRecipe(BaseRecipe recipe) {
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    public static class RemoveInput
    implements IUndoableAction {
        private final IIngredient output;
        List<BaseRecipe> removedRecipes = new ArrayList<BaseRecipe>();
        private final String name;

        public RemoveInput(IIngredient output, String machineName) {
            this.output = output;
            this.name = machineName;
        }

        public void apply() {
            block0: for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)this.name)) {
                for (Object stack : recipeType.getInputs()) {
                    if (!(stack instanceof ItemStack) || !this.output.matches(MineTweakerMC.getIItemStack((ItemStack)((ItemStack)stack)))) continue;
                    this.removedRecipes.add((BaseRecipe)recipeType);
                    RecipeHandler.recipeList.remove(recipeType);
                    continue block0;
                }
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (BaseRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    RecipeHandler.addRecipe((IBaseRecipeType)recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing " + this.name + " recipe";
        }

        public String describeUndo() {
            return "Re-Adding " + this.name + " recipe";
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    public static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<BaseRecipe> removedRecipes = new ArrayList<BaseRecipe>();
        private final String name;

        public Remove(ItemStack output, String machineName) {
            this.output = output;
            this.name = machineName;
        }

        public void apply() {
            block0: for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)this.name)) {
                for (ItemStack stack : recipeType.getOutputs()) {
                    if (!ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)this.output, (boolean)true, (boolean)false)) continue;
                    this.removedRecipes.add((BaseRecipe)recipeType);
                    RecipeHandler.recipeList.remove(recipeType);
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipeType);
                    continue block0;
                }
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (BaseRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    RecipeHandler.addRecipe((IBaseRecipeType)recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing " + this.name + " recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding " + this.name + " recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final BaseRecipe recipe;

        public Add(BaseRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeHandler.addRecipe((IBaseRecipeType)this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            RecipeHandler.recipeList.remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Adding " + this.recipe.getRecipeName() + " recipe for " + this.recipe.getOutput(0).func_82833_r();
        }

        public String describeUndo() {
            return "Removing " + this.recipe.getRecipeName() + " recipe for " + this.recipe.getOutput(0).func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

