/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.generators.fluid;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.compat.jei.generators.fluid.FluidGeneratorRecipeCategory;

public class FluidGeneratorRecipeWrapper
extends BlankRecipeWrapper {
    private static final DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    private static final int FLUID_GENERATOR_STORAGE = 100000;
    private final FluidGeneratorRecipe baseRecipe;
    private final IDrawable energyProduced;

    public FluidGeneratorRecipeWrapper(@Nonnull IJeiHelpers jeiHelpers, @Nonnull FluidGeneratorRecipe recipe) {
        this.baseRecipe = recipe;
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        this.energyProduced = guiHelper.createDrawable(FluidGeneratorRecipeCategory.texture, 176, 3, (int)(25.0 * ((double)recipe.getEnergyPerMb() * 1000.0 / 100000.0)), 14);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        this.energyProduced.draw(minecraft, 73, 26);
        minecraft.field_71466_p.func_78276_b(formatter.format(this.baseRecipe.getEnergyPerMb() * 1000) + " FE", 70, 13, 0x444444);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(FluidStack.class, (Object)new FluidStack(this.baseRecipe.getFluid(), 1000));
    }

    static {
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator(' ');
        formatter.setDecimalFormatSymbols(symbols);
    }
}

