/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;

public class RollingMachineRecipe {
    public static final RollingMachineRecipe instance = new RollingMachineRecipe();
    private final List<IRecipe> recipes = new ArrayList<IRecipe>();

    public void addShapedOreRecipe(ItemStack outputItemStack, Object ... objectInputs) {
        Validate.notNull((Object)outputItemStack);
        Validate.notNull((Object)outputItemStack.func_77973_b());
        if (objectInputs.length == 0) {
            Validate.notNull(null);
        }
        this.recipes.add((IRecipe)new ShapedOreRecipe(outputItemStack, objectInputs));
    }

    public void addShapelessOreRecipe(ItemStack outputItemStack, Object ... objectInputs) {
        Validate.notNull((Object)outputItemStack);
        Validate.notNull((Object)outputItemStack.func_77973_b());
        if (objectInputs.length == 0) {
            Validate.notNull(null);
        }
        this.recipes.add((IRecipe)new ShapelessOreRecipe(outputItemStack, objectInputs));
    }

    public void addRecipe(ItemStack output, Object ... components) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (components[i] instanceof String[]) {
            String[] as = (String[])components[i++];
            for (int l = 0; l < as.length; ++l) {
                String s2 = as[l];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (components[i] instanceof String) {
                String s1 = (String)components[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i < components.length) {
            Character character = (Character)components[i];
            ItemStack itemstack1 = null;
            if (components[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)components[i + 1]);
            } else if (components[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)components[i + 1], 1, -1);
            } else if (components[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)components[i + 1];
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        ItemStack[] recipeArray = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c = s.charAt(i1);
            recipeArray[i1] = hashmap.containsKey(Character.valueOf(c)) ? ((ItemStack)hashmap.get(Character.valueOf(c))).func_77946_l() : null;
        }
        this.recipes.add((IRecipe)new ShapedRecipes(j, k, recipeArray, output));
    }

    public void addShapelessRecipe(ItemStack output, Object ... components) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int j = 0; j < components.length; ++j) {
            Object obj = components[j];
            if (obj instanceof ItemStack) {
                ingredients.add(((ItemStack)obj).func_77946_l());
                continue;
            }
            if (obj instanceof Item) {
                ingredients.add(new ItemStack((Item)obj));
                continue;
            }
            if (obj instanceof Block) {
                ingredients.add(new ItemStack((Block)obj));
                continue;
            }
            throw new RuntimeException("Invalid shapeless recipe!");
        }
        this.recipes.add((IRecipe)new ShapelessRecipes(output, ingredients));
    }

    public ItemStack findMatchingRecipe(InventoryCrafting inv, World world) {
        for (int k = 0; k < this.recipes.size(); ++k) {
            IRecipe irecipe = this.recipes.get(k);
            if (!irecipe.func_77569_a(inv, world)) continue;
            return irecipe.func_77572_b(inv);
        }
        return null;
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

