/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.multiblock.structure;

import com.valkyrieofnight.valkyrielib.multiblock.IControllerTile;
import com.valkyrieofnight.valkyrielib.multiblock.ISlaveTile;
import com.valkyrieofnight.valkyrielib.multiblock.VLTileSlave;
import com.valkyrieofnight.valkyrielib.multiblock.structure.ComponentRegistry;
import com.valkyrieofnight.valkyrielib.multiblock.structure.MultiblockComponent;
import com.valkyrieofnight.valkyrielib.util.BlockOffset;
import com.valkyrieofnight.valkyrielib.util.helpers.ColorUtil;
import com.valkyrieofnight.valkyrielib.util.helpers.LanguageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiBlockStructure {
    private HashMap<BlockOffset, MultiblockComponent> blockLayout = new HashMap();
    private HashMap<BlockOffset, MultiblockComponent> optionalBlocks = new HashMap();
    public static int BLOCK_SETUP_INVALID = -1;
    private HashMap<InformationPosition, List<String>> information = new HashMap();

    public MultiBlockStructure() {
        for (InformationPosition ip : InformationPosition.values()) {
            this.information.put(ip, new ArrayList());
        }
    }

    public int verifyLayoutAndGetDirection(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            if (!this.isLayoutValid(world, pos, dir)) continue;
            return dir.func_176745_a();
        }
        return BLOCK_SETUP_INVALID;
    }

    public void assignMultiblock(World world, BlockPos controller, List<BlockPos> slaves) {
        TileEntity cont = world.func_175625_s(controller);
        if (!(cont instanceof IControllerTile)) {
            throw new IllegalArgumentException("Controller must be of type IControllerTile");
        }
        for (BlockPos pos : slaves) {
            TileEntity slave = world.func_175625_s(pos);
            if (!(slave instanceof VLTileSlave) || slave.func_145831_w() == null) continue;
            ((ISlaveTile)slave).setController(cont);
        }
    }

    public List<BlockPos> getSlavePositions(World world, BlockPos master, EnumFacing dir) {
        ArrayList<BlockPos> slavePositions = new ArrayList<BlockPos>();
        for (BlockOffset bo : this.blockLayout.keySet()) {
            slavePositions.add(bo.getRotatedPosition(dir, master));
        }
        return slavePositions;
    }

    public List<BlockPos> getSlavesOfType(Class slaveType, BlockPos master, EnumFacing dir) {
        ArrayList<BlockPos> slavePositions = new ArrayList<BlockPos>();
        for (BlockOffset key : this.blockLayout.keySet()) {
            if (!this.blockLayout.get(key).isType(slaveType)) continue;
            slavePositions.add(key.getRotatedPosition(dir, master));
        }
        return slavePositions;
    }

    public boolean isLayoutValid(World world, BlockPos pos, EnumFacing dir) {
        for (BlockOffset bo : this.blockLayout.keySet()) {
            MultiblockComponent comp = this.blockLayout.get(bo);
            if (comp.isCorrectComponent(world, bo.getRotatedPosition(dir, pos))) continue;
            return false;
        }
        return true;
    }

    public boolean isValidComponent(World world, BlockPos contPos, BlockPos compPos) {
        MultiblockComponent comp = this.blockLayout.get(BlockOffset.getOffset(contPos, compPos));
        return comp != null && comp.isCorrectComponent(world, compPos);
    }

    public boolean isValidComponent(World world, BlockPos contPos, BlockOffset compOffset, EnumFacing testDirection) {
        MultiblockComponent comp = this.blockLayout.get(compOffset);
        return comp != null && comp.isCorrectComponent(world, compOffset.getRotatedPosition(testDirection, contPos));
    }

    public HashMap<BlockOffset, MultiblockComponent> getRequiredBlockLayout() {
        return this.blockLayout;
    }

    public void placeAllInWorld(World world, EntityPlayer player, BlockPos pos) {
        for (BlockOffset bo : this.blockLayout.keySet()) {
            MultiblockComponent comp = this.blockLayout.get(bo);
            world.func_175656_a(bo.getPosition(pos), comp.getBlockState());
        }
    }

    public void pickupMultiBlock(World world, EntityPlayer player, BlockPos pos) {
        for (BlockOffset bo : this.blockLayout.keySet()) {
            MultiblockComponent comp = this.blockLayout.get(bo);
            world.func_175656_a(bo.getPosition(pos), Blocks.field_150350_a.func_176223_P());
        }
    }

    public boolean placeNextBlock(World world, EntityPlayer player, BlockPos pos) {
        for (BlockOffset bo : this.blockLayout.keySet()) {
            if (this.blockLayout.get(bo).isCorrectComponent(world, bo.getPosition(pos)) || !world.func_180495_p(bo.getPosition(pos)).func_177230_c().equals(Blocks.field_150350_a)) continue;
            MultiblockComponent icomp = this.blockLayout.get(bo);
            List pInv = player.field_71069_bz.func_75138_a();
            for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (stack == null || !icomp.isCorrectItemStack(stack) || stack.field_77994_a <= 0) continue;
                world.func_175656_a(bo.getPosition(pos), Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j()));
                player.field_71071_by.func_70298_a(slot, 1);
                return true;
            }
        }
        return false;
    }

    protected boolean positionTaken(BlockOffset offset) {
        for (BlockOffset rb : this.blockLayout.keySet()) {
            if (!rb.equals(offset)) continue;
            return true;
        }
        for (BlockOffset rb : this.optionalBlocks.keySet()) {
            if (!rb.equals(offset)) continue;
            return true;
        }
        return false;
    }

    public void addRequiredBlock(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        BlockOffset offset = new BlockOffset(xOffset, yOffset, zOffset);
        if (!this.positionTaken(offset)) {
            this.blockLayout.put(offset, comp);
        }
    }

    public void addOptionalBlock(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        BlockOffset os = new BlockOffset(xOffset, yOffset, zOffset);
        if (!this.positionTaken(os)) {
            this.optionalBlocks.put(os, comp);
        }
    }

    public void addOffsetReqCompParallelX(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0) {
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
        } else {
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
            this.addRequiredBlock(comp, -xOffset, yOffset, zOffset);
        }
    }

    public void addOffsetOptCompParallelX(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0) {
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
        } else {
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
            this.addOptionalBlock(comp, -xOffset, yOffset, zOffset);
        }
    }

    public void addOffsetReqCompParallelY(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        if (yOffset == 0) {
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
        } else {
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
            this.addRequiredBlock(comp, xOffset, -yOffset, zOffset);
        }
    }

    public void addOffsetOptCompParallelY(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        if (yOffset == 0) {
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
        } else {
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
            this.addOptionalBlock(comp, xOffset, -yOffset, zOffset);
        }
    }

    public void addOffsetReqCompParallelZ(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        if (zOffset == 0) {
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
        } else {
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
            this.addRequiredBlock(comp, xOffset, yOffset, -zOffset);
        }
    }

    public void addOffsetOptCompParallelZ(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        if (zOffset == 0) {
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
        } else {
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
            this.addOptionalBlock(comp, xOffset, yOffset, -zOffset);
        }
    }

    public void addOffsetReqCompSymmetrical(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0 && zOffset == 0) {
            if (yOffset == 0) {
                return;
            }
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
        } else if (Math.abs(xOffset) == Math.abs(zOffset)) {
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
            this.addRequiredBlock(comp, -xOffset, yOffset, zOffset);
            this.addRequiredBlock(comp, xOffset, yOffset, -zOffset);
            this.addRequiredBlock(comp, -xOffset, yOffset, -zOffset);
        } else if (xOffset == 0 || zOffset == 0) {
            int off = Math.max(xOffset, zOffset);
            this.addRequiredBlock(comp, off, yOffset, 0);
            this.addRequiredBlock(comp, -off, yOffset, 0);
            this.addRequiredBlock(comp, 0, yOffset, off);
            this.addRequiredBlock(comp, 0, yOffset, -off);
        } else {
            this.addRequiredBlock(comp, xOffset, yOffset, zOffset);
            this.addRequiredBlock(comp, -xOffset, yOffset, zOffset);
            this.addRequiredBlock(comp, xOffset, yOffset, -zOffset);
            this.addRequiredBlock(comp, -xOffset, yOffset, -zOffset);
            this.addRequiredBlock(comp, zOffset, yOffset, xOffset);
            this.addRequiredBlock(comp, -zOffset, yOffset, xOffset);
            this.addRequiredBlock(comp, zOffset, yOffset, -xOffset);
            this.addRequiredBlock(comp, -zOffset, yOffset, -xOffset);
        }
    }

    public void addOffsetOptCompSymmetrical(MultiblockComponent comp, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0 && zOffset == 0) {
            if (yOffset == 0) {
                return;
            }
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
        } else if (Math.abs(xOffset) == Math.abs(zOffset)) {
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
            this.addOptionalBlock(comp, -xOffset, yOffset, zOffset);
            this.addOptionalBlock(comp, xOffset, yOffset, -zOffset);
            this.addOptionalBlock(comp, -xOffset, yOffset, -zOffset);
        } else if (xOffset == 0 || zOffset == 0) {
            int off = Math.max(xOffset, zOffset);
            this.addOptionalBlock(comp, off, yOffset, 0);
            this.addOptionalBlock(comp, -off, yOffset, 0);
            this.addOptionalBlock(comp, 0, yOffset, off);
            this.addOptionalBlock(comp, 0, yOffset, -off);
        } else {
            this.addOptionalBlock(comp, xOffset, yOffset, zOffset);
            this.addOptionalBlock(comp, -xOffset, yOffset, zOffset);
            this.addOptionalBlock(comp, xOffset, yOffset, -zOffset);
            this.addOptionalBlock(comp, -xOffset, yOffset, -zOffset);
            this.addOptionalBlock(comp, zOffset, yOffset, xOffset);
            this.addOptionalBlock(comp, -zOffset, yOffset, xOffset);
            this.addOptionalBlock(comp, zOffset, yOffset, -xOffset);
            this.addOptionalBlock(comp, -zOffset, yOffset, -xOffset);
        }
    }

    public List<String> getListOfRequiredBlocks() {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<MultiblockComponent, Integer> totals = new HashMap<MultiblockComponent, Integer>();
        for (MultiblockComponent comp : this.blockLayout.values()) {
            if (totals.containsKey(comp)) {
                int i = (Integer)totals.get(comp);
                totals.put(comp, ++i);
                continue;
            }
            totals.put(comp, 1);
        }
        list.addAll((Collection)this.information.get((Object)InformationPosition.TITLE));
        list.addAll((Collection)this.information.get((Object)InformationPosition.ABOVE_LIST));
        list.add(ColorUtil.DARK_AQUA + LanguageHelper.toLoc("gui.environmentaltech.multiblockassembler.info.needed.title"));
        for (MultiblockComponent comp : ComponentRegistry.getInstance().getList()) {
            if (!totals.containsKey(comp)) continue;
            int n = (Integer)totals.get(comp);
            String str = "  " + ColorUtil.DARK_PURPLE + n + " " + ColorUtil.BLUE + "x " + ColorUtil.GOLD + comp.getRequired();
            list.add(str);
        }
        list.addAll((Collection)this.information.get((Object)InformationPosition.BELOW_LIST));
        return list;
    }

    public List<String> getListOfRequiredBlocksGuide() {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<MultiblockComponent, Integer> totals = new HashMap<MultiblockComponent, Integer>();
        for (MultiblockComponent comp : this.blockLayout.values()) {
            if (totals.containsKey(comp)) {
                int i = (Integer)totals.get(comp);
                totals.put(comp, ++i);
                continue;
            }
            totals.put(comp, 1);
        }
        for (MultiblockComponent comp : ComponentRegistry.getInstance().getList()) {
            if (!totals.containsKey(comp)) continue;
            int n = (Integer)totals.get(comp);
            String str = "  " + ColorUtil.DARK_PURPLE + n + " " + ColorUtil.BLUE + "x " + ColorUtil.BLACK + comp.getRequired();
            list.add(str);
        }
        return list;
    }

    public int getTotalRequiredComponent(Class clazz) {
        int total = 0;
        for (MultiblockComponent comp : this.blockLayout.values()) {
            if (!comp.isType(clazz)) continue;
            ++total;
        }
        return total;
    }

    public void addInformation(InformationPosition pos, String localizedText) {
        List<String> posList = this.information.get((Object)pos);
        posList.add(localizedText);
    }

    public static enum InformationPosition {
        TITLE,
        ABOVE_LIST,
        BELOW_LIST;

    }
}

