/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.ctm;

import com.valkyrieofnight.valkyrielib.ctm.ISubmap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class Submap
implements ISubmap {
    private static final float FACTOR = 16.0f;
    protected ISubmap normalized = new SubmapNormalized(this);
    private final float x;
    private final float y;
    private final float width;
    private final float height;

    public Submap(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public float getXOffset() {
        return this.x;
    }

    @Override
    public float getYOffset() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
        return sprite.func_94214_a((double)(this.getXOffset() + u / this.getWidth()));
    }

    @Override
    public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
        return sprite.func_94207_b((double)(this.getYOffset() + v / this.getHeight()));
    }

    @Override
    public ISubmap getRelative() {
        return this;
    }

    @Override
    public ISubmap getNormalized() {
        return this.normalized;
    }

    private static class SubmapNormalized
    implements ISubmap {
        private final ISubmap relative;

        public SubmapNormalized(ISubmap relative) {
            this.relative = relative;
        }

        @Override
        public float getXOffset() {
            return this.relative.getXOffset() / 16.0f;
        }

        @Override
        public float getYOffset() {
            return this.relative.getYOffset() / 16.0f;
        }

        @Override
        public float getWidth() {
            return this.relative.getWidth() / 16.0f;
        }

        @Override
        public float getHeight() {
            return this.relative.getHeight() / 16.0f;
        }

        @Override
        public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
            return this.relative.getInterpolatedU(sprite, u);
        }

        @Override
        public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
            return this.relative.getInterpolatedV(sprite, v);
        }

        @Override
        public ISubmap getRelative() {
            return this.relative;
        }

        @Override
        public ISubmap getNormalized() {
            return this;
        }
    }
}

