/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.api.state.enums.CrateVariant;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileCraftCrate;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockOpenCrate
extends BlockMod
implements ILexiconable,
IWandable,
IWandHUD {
    public BlockOpenCrate() {
        super(Material.field_151575_d, "openCrate");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CRATE_VARIANT, BotaniaStateProps.CRATE_PATTERN});
    }

    @Override
    protected IBlockState pickDefaultState() {
        return this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CRATE_VARIANT, (Comparable)((Object)CrateVariant.OPEN)).func_177226_a(BotaniaStateProps.CRATE_PATTERN, (Comparable)((Object)CratePattern.NONE));
    }

    public int func_176201_c(IBlockState state) {
        return ((CrateVariant)((Object)state.func_177229_b(BotaniaStateProps.CRATE_VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta >= CrateVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CRATE_VARIANT, (Comparable)((Object)CrateVariant.values()[meta]));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof TileCraftCrate) {
            TileCraftCrate tile = (TileCraftCrate)te;
            state = state.func_177226_a(BotaniaStateProps.CRATE_PATTERN, (Comparable)((Object)CratePattern.values()[tile.pattern + 1]));
        } else {
            state = state.func_177226_a(BotaniaStateProps.CRATE_PATTERN, (Comparable)((Object)CratePattern.NONE));
        }
        return state;
    }

    @Override
    public void registerItemForm() {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockWithMetadataAndName(this), (ResourceLocation)this.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> stacks) {
        for (int i = 0; i < CrateVariant.values().length; ++i) {
            stacks.add(new ItemStack(item, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileOpenCrate crate = (TileOpenCrate)world.func_175625_s(pos);
        return crate.getSignal();
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!world.field_72995_K) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.dropInventory(inv, world, state, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return state.func_177229_b(BotaniaStateProps.CRATE_VARIANT) == CrateVariant.OPEN ? new TileOpenCrate() : new TileCraftCrate();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return world.func_180495_p(pos).func_177229_b(BotaniaStateProps.CRATE_VARIANT) == CrateVariant.OPEN ? LexiconData.openCrate : LexiconData.craftCrate;
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        TileOpenCrate crate = (TileOpenCrate)world.func_175625_s(pos);
        return crate.onWanded(world, player, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCraftCrate) {
            TileCraftCrate craft = (TileCraftCrate)tile;
            int width = 52;
            int height = 52;
            int xc = res.func_78326_a() / 2 + 20;
            int yc = res.func_78328_b() / 2 - height / 2;
            Gui.func_73734_a((int)(xc - 6), (int)(yc - 6), (int)(xc + width + 6), (int)(yc + height + 6), (int)0x22000000);
            Gui.func_73734_a((int)(xc - 4), (int)(yc - 4), (int)(xc + width + 4), (int)(yc + height + 4), (int)0x22000000);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    int xp = xc + j * 18;
                    int yp = yc + i * 18;
                    boolean enabled = true;
                    if (craft.pattern > -1) {
                        enabled = TileCraftCrate.PATTERNS[craft.pattern][index];
                    }
                    Gui.func_73734_a((int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)(enabled ? 0x22FFFFFF : 0x22FF0000));
                    ItemStack item = craft.getItemHandler().getStackInSlot(index);
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179091_B();
                    mc.func_175599_af().func_180450_b(item, xp, yp);
                    RenderHelper.func_74518_a();
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerBlockToState(this, 0, this.func_176223_P());
        ModelHandler.registerBlockToState(this, 1, this.func_176223_P().func_177226_a(BotaniaStateProps.CRATE_VARIANT, (Comparable)((Object)CrateVariant.CRAFTY)));
    }
}

