/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.data;

import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.mod.booklet.gui.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.misc.BookletUtils;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PlayerData {
    public static PlayerSave getDataFromPlayer(UUID id) {
        ArrayList<PlayerSave> data = WorldData.getWorldUnspecificData().playerSaveData;
        for (PlayerSave save : data) {
            if (save.id == null || !save.id.equals(id)) continue;
            return save;
        }
        PlayerSave aSave = new PlayerSave(id);
        data.add(aSave);
        return aSave;
    }

    public static PlayerSave getDataFromPlayer(EntityPlayer player) {
        return PlayerData.getDataFromPlayer(player.func_110124_au());
    }

    public static class PlayerSave {
        public UUID id;
        public boolean displayTesla;
        public boolean bookGottenAlready;
        public boolean didBookTutorial;
        public IBookletPage[] bookmarks = new IBookletPage[12];
        @SideOnly(value=Side.CLIENT)
        public GuiBooklet lastOpenBooklet;

        public PlayerSave(UUID id) {
            this.id = id;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.displayTesla = compound.func_74767_n("DisplayTesla");
            this.bookGottenAlready = compound.func_74767_n("BookGotten");
            this.didBookTutorial = compound.func_74767_n("DidTutorial");
            NBTTagList bookmarks = compound.func_150295_c("Bookmarks", 8);
            for (int i = 0; i < bookmarks.func_74745_c(); ++i) {
                IBookletPage page;
                String strg = bookmarks.func_150307_f(i);
                if (strg == null || strg.isEmpty()) continue;
                this.bookmarks[i] = page = BookletUtils.getBookletPageById(strg);
            }
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74757_a("DisplayTesla", this.displayTesla);
            compound.func_74757_a("BookGotten", this.bookGottenAlready);
            compound.func_74757_a("DidTutorial", this.didBookTutorial);
            NBTTagList bookmarks = new NBTTagList();
            for (IBookletPage bookmark : this.bookmarks) {
                bookmarks.func_74742_a((NBTBase)new NBTTagString(bookmark == null ? "" : bookmark.getIdentifier()));
            }
            compound.func_74782_a("Bookmarks", (NBTBase)bookmarks);
        }
    }
}

