/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlabs
extends BlockBase {
    public static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)1);
    private final Block fullBlock;
    private final int meta;

    public BlockSlabs(String name, Block fullBlock) {
        this(name, fullBlock, 0);
    }

    public BlockSlabs(String name, Block fullBlock, int meta) {
        super(fullBlock.func_149688_o(fullBlock.func_176223_P()), name);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.fullBlock = fullBlock;
        this.meta = meta;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing.ordinal() == 1) {
            return this.func_176203_a(meta);
        }
        if (facing.ordinal() == 0 || hitY >= 0.5f) {
            return this.func_176203_a(meta + 1);
        }
        return this.func_176203_a(meta);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)META) == 1 ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    @Override
    protected ItemBlockBase getItemBlock() {
        return new TheItemBlock(this);
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    @Override
    protected PropertyInteger getMetaProperty() {
        return META;
    }

    public static class TheItemBlock
    extends ItemBlockBase {
        public TheItemBlock(Block block) {
            super(block);
            this.func_77627_a(false);
            this.func_77656_e(0);
        }

        public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            if (StackUtil.isValid(stack) && playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
                IBlockState state = worldIn.func_180495_p(pos);
                if (state.func_177230_c() == this.field_150939_a) {
                    BlockSlabs theBlock = (BlockSlabs)this.field_150939_a;
                    if (facing == EnumFacing.UP && (Integer)state.func_177229_b((IProperty)META) == 0 || facing == EnumFacing.DOWN && (Integer)state.func_177229_b((IProperty)META) == 1) {
                        IBlockState newState = theBlock.fullBlock.func_176203_a(theBlock.meta);
                        AxisAlignedBB bound = newState.func_185890_d(worldIn, pos);
                        if (bound != Block.field_185506_k && worldIn.func_72855_b(bound.func_186670_a(pos)) && worldIn.func_180501_a(pos, newState, 11)) {
                            SoundType soundtype = theBlock.fullBlock.func_185467_w();
                            worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                            playerIn.func_184611_a(hand, StackUtil.addStackSize(stack, -1));
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
                return this.tryPlace(playerIn, stack, hand, worldIn, pos.func_177972_a(facing)) ? EnumActionResult.SUCCESS : super.func_180614_a(stack, playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            }
            return EnumActionResult.FAIL;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
            IBlockState state = worldIn.func_180495_p(pos);
            if (state.func_177230_c() == this.field_150939_a && (side == EnumFacing.UP && (Integer)state.func_177229_b((IProperty)META) == 0 || side == EnumFacing.DOWN && (Integer)state.func_177229_b((IProperty)META) == 1)) {
                return true;
            }
            return worldIn.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this.field_150939_a || super.func_179222_a(worldIn, pos, side, player, stack);
        }

        private boolean tryPlace(EntityPlayer player, ItemStack stack, EnumHand hand, World worldIn, BlockPos pos) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (iblockstate.func_177230_c() == this.field_150939_a) {
                BlockSlabs theBlock = (BlockSlabs)this.field_150939_a;
                IBlockState newState = theBlock.fullBlock.func_176203_a(theBlock.meta);
                AxisAlignedBB bound = newState.func_185890_d(worldIn, pos);
                if (bound != Block.field_185506_k && worldIn.func_72855_b(bound.func_186670_a(pos)) && worldIn.func_180501_a(pos, newState, 11)) {
                    SoundType soundtype = theBlock.fullBlock.func_185467_w();
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    player.func_184611_a(hand, StackUtil.addStackSize(stack, -1));
                }
                return true;
            }
            return false;
        }

        @Override
        public String func_77667_c(ItemStack stack) {
            return this.func_77658_a();
        }
    }
}

