/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheColoredLampColors;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BlockColoredLamp
extends BlockBase {
    public static final TheColoredLampColors[] ALL_LAMP_TYPES = TheColoredLampColors.values();
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)(ALL_LAMP_TYPES.length - 1));
    public final boolean isOn;

    public BlockColoredLamp(boolean isOn, String name) {
        super(Material.field_151591_t, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(3.0f);
        this.isOn = isOn;
    }

    public Item func_180660_a(IBlockState state, Random rand, int par3) {
        return Item.func_150898_a((Block)InitBlocks.blockColoredLamp);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        int[] oreIDs;
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                world.func_180501_a(pos, (this.isOn ? InitBlocks.blockColoredLamp : InitBlocks.blockColoredLampOn).func_176203_a(this.func_176201_c(state)), 2);
            }
            return true;
        }
        if (StackUtil.isValid(stack) && (oreIDs = OreDictionary.getOreIDs((ItemStack)stack)).length > 0) {
            for (int oreID : oreIDs) {
                String name = OreDictionary.getOreName((int)oreID);
                TheColoredLampColors color = TheColoredLampColors.getColorFromDyeName(name);
                if (color == null || this.func_176201_c(state) == color.ordinal()) continue;
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, this.func_176203_a(color.ordinal()), 2);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(InitBlocks.blockColoredLamp, 1, this.func_176201_c(state));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j < ALL_LAMP_TYPES.length; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isOn ? 15 : 0;
    }

    @Override
    protected ItemBlockBase getItemBlock() {
        return new TheItemBlock(this);
    }

    @Override
    protected void registerRendering() {
        for (int i = 0; i < ALL_LAMP_TYPES.length; ++i) {
            ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Block)this, 1, i), this.getRegistryName(), META.func_177701_a() + "=" + i);
        }
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    protected PropertyInteger getMetaProperty() {
        return META;
    }

    public static class TheItemBlock
    extends ItemBlockBase {
        public TheItemBlock(Block block) {
            super(block);
            this.func_77627_a(true);
            this.func_77656_e(0);
        }

        public String func_77653_i(ItemStack stack) {
            if (stack.func_77952_i() >= ALL_LAMP_TYPES.length) {
                return "actuallyadditions.lolWutHowUDoDis";
            }
            return StringUtil.localize(this.func_77667_c(stack) + ".name") + (((BlockColoredLamp)this.field_150939_a).isOn ? " (" + StringUtil.localize("tooltip.actuallyadditions.onSuffix.desc") + ")" : "");
        }

        @Override
        public String func_77667_c(ItemStack stack) {
            return InitBlocks.blockColoredLamp.func_149739_a() + BlockColoredLamp.ALL_LAMP_TYPES[stack.func_77952_i()].name;
        }
    }
}

