/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityGhostPlayer
extends EntityMob {
    private static final DataParameter<String> PLAYER_UUID = EntityDataManager.func_187226_a(EntityGhostPlayer.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityGhostPlayer(World worldIn, UUID playerUUID, String playerName) {
        this(worldIn);
        this.setPlayerUUID(playerUUID);
        this.func_96094_a(playerName);
    }

    public EntityGhostPlayer(World worldIn) {
        super(worldIn);
        this.func_174805_g(false);
        this.func_70105_a(0.6f, 1.95f);
    }

    public boolean func_94059_bO() {
        return this.func_174833_aM();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(10, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PLAYER_UUID, (Object)new UUID(0L, 0L).toString());
    }

    public boolean func_70662_br() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public void setPlayerUUID(UUID uuid) {
        this.func_184212_Q().func_187227_b(PLAYER_UUID, (Object)uuid.toString());
        if (uuid.toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            this.setOverpowered();
        }
    }

    private void setOverpowered() {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        if (name.equals("henkelmax")) {
            this.setOverpowered();
        }
    }

    public UUID getPlayerUUID() {
        String uuidStr = (String)this.func_184212_Q().func_187225_a(PLAYER_UUID);
        UUID uuid = new UUID(0L, 0L);
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("player_uuid", this.getPlayerUUID().toString());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("player_uuid")) {
            String uuidStr = compound.func_74779_i("player_uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                this.setPlayerUUID(uuid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn.func_70005_c_().equals("henkelmax") || entityIn.func_110124_au().toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            return true;
        }
        return super.func_70652_k(entityIn);
    }
}

