/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.inventory;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.common.inventory.ContainerChisel;
import team.chisel.common.inventory.InventoryChiselSelection;
import team.chisel.common.inventory.SlotChiselInput;
import team.chisel.common.inventory.SlotChiselSelection;
import team.chisel.common.util.NBTUtil;

public class ContainerChiselHitech
extends ContainerChisel {
    private Slot selection;
    private Slot target;
    private List<Slot> selectionDuplicates;
    private ICarvingGroup currentGroup;

    public ContainerChiselHitech(InventoryPlayer inventoryplayer, InventoryChiselSelection inv, EnumHand hand) {
        super(inventoryplayer, inv, hand);
        int targetSlot;
        int selectionSlot = NBTUtil.getHitechSelection(this.chisel);
        if (selectionSlot >= 0) {
            this.setSelection(this.func_75139_a(selectionSlot));
        }
        if ((targetSlot = NBTUtil.getHitechTarget(this.chisel)) >= 0) {
            this.setTarget(this.func_75139_a(targetSlot));
        }
    }

    public void setSelection(Slot slot) {
        this.selection = slot;
        if (slot == null || !slot.func_75216_d()) {
            this.currentGroup = null;
            this.selectionDuplicates = ImmutableList.of();
            this.setTarget(null);
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = this.getInventoryChisel().size + 1; i < this.field_75151_b.size(); ++i) {
                Slot s = this.func_75139_a(i);
                if (slot == s || !ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)s.func_75211_c())) continue;
                builder.add((Object)s);
            }
            this.selectionDuplicates = builder.build();
            ICarvingGroup group = this.carving.getGroup(slot.func_75211_c());
            if (group != this.currentGroup) {
                this.setTarget(null);
            }
            this.currentGroup = group;
        }
        ItemStack stack = slot == null ? null : slot.func_75211_c();
        this.getInventoryChisel().func_70299_a(this.getInventoryChisel().size, stack == null ? null : stack.func_77946_l());
        this.getInventoryChisel().updateItems();
    }

    public ItemStack getSelectionStack() {
        return this.getSelection() == null ? null : this.getSelection().func_75211_c();
    }

    public ItemStack getTargetStack() {
        return this.getTarget() == null ? null : this.getTarget().func_75211_c();
    }

    @Override
    protected void addSlots() {
        int i;
        int top = 8;
        int left = 88;
        for (i = 0; i < this.getInventoryChisel().size; ++i) {
            this.func_75146_a(new SlotChiselSelection(this, this.inventoryChisel, this.inventoryChisel, i, left + i % 9 * 18, top + i / 9 * 18));
        }
        this.func_75146_a(new SlotChiselInput(this, this.inventoryChisel, this.getInventoryChisel().size, -1000, 0));
        top += 130;
        for (i = 0; i < 27; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i + 9, left + i % 9 * 18, top + i / 9 * 18));
        }
        top += 58;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i, left + i % 9 * 18, top + i / 9 * 18));
        }
    }

    @Override
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0) {
            Slot slot = this.func_75139_a(slotId);
            if (slotId < this.getInventoryChisel().size) {
                this.setTarget(slot);
            } else if (dragType == 1) {
                ItemStack toFind = slot.func_75211_c();
                if (toFind != null) {
                    for (int i = 0; i < this.getInventoryChisel().size; ++i) {
                        if (!ItemStack.func_179545_c((ItemStack)toFind, (ItemStack)this.getInventoryChisel().func_70301_a(i))) continue;
                        this.setTarget(this.func_75139_a(i));
                    }
                }
            } else {
                this.setSelection(slot);
            }
        }
        return null;
    }

    public Slot getSelection() {
        return this.selection;
    }

    public Slot getTarget() {
        return this.target;
    }

    public List<Slot> getSelectionDuplicates() {
        return this.selectionDuplicates;
    }

    public ICarvingGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public void setTarget(Slot target) {
        this.target = target;
    }

    public void setSelectionDuplicates(List<Slot> selectionDuplicates) {
        this.selectionDuplicates = selectionDuplicates;
    }

    public void setCurrentGroup(ICarvingGroup currentGroup) {
        this.currentGroup = currentGroup;
    }
}

