/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.util;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GistAPI {
    private static final Gson gson = new Gson();

    private static String sendHttpRequest(URL url, String method, String content) throws IOException {
        String line;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", "application/json");
        if (content != null && !content.isEmpty()) {
            byte[] postDataBytes = content.getBytes("UTF-8");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postDataBytes);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder.toString();
    }

    public static GistResponse createGist(String desc, boolean _public, GistFile ... content) throws IOException {
        URL url = new URL("https://api.github.com/gists");
        String response = GistAPI.sendHttpRequest(url, "POST", gson.toJson((Object)new Gist(desc, _public, content)));
        return (GistResponse)gson.fromJson(response, GistResponse.class);
    }

    public static Gist getGist(URL url) throws IOException {
        String response = GistAPI.sendHttpRequest(url, "GET", null);
        return (Gist)gson.fromJson(response, Gist.class);
    }

    public static class Gist {
        private String description;
        @SerializedName(value="public")
        private boolean _public;
        private Map<String, GistFile> files = new HashMap<String, GistFile>();

        private Gist(String description, boolean _public, GistFile ... files) {
            this.description = description;
            this._public = _public;
            Arrays.stream(files).forEach(f -> this.files.put(((GistFile)f).name, (GistFile)f));
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, GistFile> getFiles() {
            return this.files;
        }
    }

    public static class GistResponse {
        private String html_url;
        private String id;

        public String getURL() {
            return this.html_url;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class GistFile {
        private String content;
        private String name;

        public GistFile() {
        }

        public GistFile(String name, String content) {
            this.content = content;
            this.name = name;
        }

        public String toString() {
            return this.content;
        }

        public String getContent() {
            return this.content;
        }

        public String getName() {
            return this.name;
        }
    }
}

