/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.network;

import com.amadornes.rscircuits.network.LocatedPacket;
import com.amadornes.rscircuits.network.Packet;
import com.amadornes.rscircuits.network.PacketCircuitUpdate;
import com.amadornes.rscircuits.network.PacketColorPick;
import com.amadornes.rscircuits.network.PacketCustomPayload;
import com.amadornes.rscircuits.network.PacketPlacementData;
import com.amadornes.rscircuits.network.PacketSpawnMagicSmoke;
import com.amadornes.rscircuits.network.PacketSplit;
import com.amadornes.rscircuits.network.PacketTrayScroll;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkHandler {
    public static final NetworkHandler instance = new NetworkHandler("rscircuits");
    public final SimpleNetworkWrapper wrapper;
    private int lastDiscriminator = 0;
    BiMap<Pair<Class<Packet<?>>, Side>, Integer> discriminatorMap = HashBiMap.create();

    public NetworkHandler(String modid) {
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(modid);
    }

    public static void init() {
        instance.registerPacket(PacketPlacementData.class, Side.SERVER);
        instance.registerPacket(PacketCircuitUpdate.class, Side.CLIENT);
        instance.registerPacket(PacketCustomPayload.class, Side.SERVER);
        instance.registerPacket(PacketTrayScroll.class, Side.SERVER);
        instance.registerPacket(PacketColorPick.class, Side.SERVER);
        instance.registerPacket(PacketSpawnMagicSmoke.class, Side.CLIENT);
        instance.registerPacket(PacketSplit.class, Side.CLIENT);
        instance.registerPacket(PacketSplit.class, Side.SERVER);
    }

    public void registerPacket(Class packetHandler, Class packetType, Side side) {
        this.wrapper.registerMessage(packetHandler, packetType, this.lastDiscriminator, side);
        this.discriminatorMap.put((Object)Pair.of((Object)packetType, (Object)side), (Object)this.lastDiscriminator++);
    }

    public void registerPacket(Class packetType, Side side) {
        this.wrapper.registerMessage(packetType, packetType, this.lastDiscriminator, side);
        this.discriminatorMap.put((Object)Pair.of((Object)packetType, (Object)side), (Object)this.lastDiscriminator++);
    }

    public void sendToAll(Packet<?> packet) {
        this.wrapper.sendToAll(packet);
        List<PacketSplit> split = PacketSplit.split(packet, Side.CLIENT);
        if (split != null) {
            split.forEach(arg_0 -> ((SimpleNetworkWrapper)this.wrapper).sendToAll(arg_0));
        } else {
            this.wrapper.sendToAll(packet);
        }
    }

    public void sendTo(Packet<?> packet, EntityPlayerMP player) {
        List<PacketSplit> split = PacketSplit.split(packet, Side.CLIENT);
        if (split != null) {
            split.forEach(p -> this.wrapper.sendTo((IMessage)p, player));
        } else {
            this.wrapper.sendTo(packet, player);
        }
    }

    public <T extends LocatedPacket<T>> void sendToAllAround(T packet, World world, double range) {
        this.sendToAllAround(packet, packet.getTargetPoint(world, range));
    }

    public <T extends LocatedPacket<T>> void sendToAllAround(T packet, World world) {
        this.sendToAllAround(packet, packet.getTargetPoint(world, 64.0));
    }

    public void sendToAllAround(Packet<?> packet, NetworkRegistry.TargetPoint point) {
        List<PacketSplit> split = PacketSplit.split(packet, Side.CLIENT);
        if (split != null) {
            split.forEach(p -> this.wrapper.sendToAllAround((IMessage)p, point));
        } else {
            this.wrapper.sendToAllAround(packet, point);
        }
    }

    public void sendToDimension(Packet<?> packet, int dimensionId) {
        List<PacketSplit> split = PacketSplit.split(packet, Side.CLIENT);
        if (split != null) {
            split.forEach(p -> this.wrapper.sendToDimension((IMessage)p, dimensionId));
        } else {
            this.wrapper.sendToDimension(packet, dimensionId);
        }
    }

    public void sendToServer(Packet<?> packet) {
        List<PacketSplit> split = PacketSplit.split(packet, Side.SERVER);
        if (split != null) {
            split.forEach(arg_0 -> ((SimpleNetworkWrapper)this.wrapper).sendToServer(arg_0));
        } else {
            this.wrapper.sendToServer(packet);
        }
    }
}

