/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.item;

import crazypants.enderzoo.EnderZooTab;
import crazypants.enderzoo.config.Config;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGuardiansBow
extends ItemBow {
    public static final String NAME = "guardiansBow";
    private int drawTime = Config.guardiansBowDrawTime;
    private float damageBonus = Config.guardiansBowDamageBonus;
    private float forceMultiplier = Config.guardiansBowForceMultiplier;
    private float fovMultiplier = Config.guardiansBowFovMultiplier;

    public static ItemGuardiansBow create() {
        ItemGuardiansBow res = new ItemGuardiansBow();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    protected ItemGuardiansBow() {
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
        this.func_77637_a(EnderZooTab.tabEnderZoo);
        this.func_77656_e(800);
        this.func_77627_a(false);
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entityLiving;
        boolean hasInfinateArrows = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack itemstack = this.getArrowsToShoot(entityplayer);
        int draw = this.func_77626_a(stack) - timeLeft;
        if ((draw = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)((EntityPlayer)entityLiving), (int)draw, (itemstack != null || hasInfinateArrows ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (itemstack == null && hasInfinateArrows) {
            itemstack = new ItemStack(Items.field_151032_g);
        }
        if (itemstack == null) {
            return;
        }
        float drawRatio = ItemGuardiansBow.func_185059_b((int)draw);
        if ((double)drawRatio >= 0.1) {
            boolean arrowIsInfinite;
            boolean bl = arrowIsInfinite = hasInfinateArrows && itemstack.func_77973_b() instanceof ItemArrow;
            if (!worldIn.field_72995_K) {
                int knockBack;
                int powerLevel;
                ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
                entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, drawRatio * (3.0f + this.forceMultiplier), 0.25f);
                if (drawRatio == 1.0f) {
                    entityarrow.func_70243_d(true);
                }
                if ((powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                    entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
                }
                if ((knockBack = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    entityarrow.func_70240_a(knockBack);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                    entityarrow.func_70015_d(100);
                }
                stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                if (arrowIsInfinite) {
                    entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)this.damageBonus + 20.0);
                worldIn.func_72838_d((Entity)entityarrow);
            }
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + drawRatio * 0.5f);
            if (!arrowIsInfinite) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a == 0) {
                    entityplayer.field_71071_by.func_184437_d(itemstack);
                }
            }
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
    }

    private ItemStack getArrowsToShoot(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFovUpdateEvent(FOVUpdateEvent fovEvt) {
        ItemStack currentItem = fovEvt.getEntity().func_184614_ca();
        if (currentItem == null || currentItem.func_77973_b() != this || fovEvt.getEntity().func_184605_cv() <= 0) {
            return;
        }
        int drawDuration = this.func_77626_a(currentItem) - fovEvt.getEntity().func_184605_cv();
        float ratio = (float)drawDuration / (float)this.getDrawTime();
        ratio = ratio > 1.0f ? 1.0f : (ratio *= ratio);
        fovEvt.setNewfov(1.0f - ratio * this.fovMultiplier);
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return 1;
    }

    public int getDrawTime() {
        return this.drawTime;
    }

    public void setDrawTime(int drawTime) {
        this.drawTime = drawTime;
    }
}

