/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualFullStomach
extends Ritual {
    public static final String FILL_RANGE = "fillRange";
    public static final String CHEST_RANGE = "chest";

    public RitualFullStomach() {
        super("ritualFullStomach", 0, 100000, "ritual.BloodMagic.fullStomachRitual");
        this.addBlockRange(FILL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-25, -25, -25), 51));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(FILL_RANGE, 0, 25, 25);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getBlockPos();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
        TileEntity tile = world.func_175625_s(chestRange.getContainedPositions(pos).get(0));
        if (!(tile instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tile;
        int lastSlot = 0;
        AreaDescriptor fillingRange = this.getBlockRange(FILL_RANGE);
        List playerList = world.func_72872_a(EntityPlayer.class, fillingRange.getAABB(pos));
        for (EntityPlayer player : playerList) {
            FoodStats foodStats = player.func_71024_bL();
            float satLevel = foodStats.func_75115_e();
            for (int i = lastSlot; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemFood)) continue;
                ItemFood foodItem = (ItemFood)stack.func_77973_b();
                int healAmount = foodItem.func_150905_g(stack);
                float saturationAmount = foodItem.func_150906_h(stack) * (float)healAmount * 2.0f;
                if (!(saturationAmount + satLevel <= 20.0f)) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                foodStats.func_75117_b(nbt);
                nbt.func_74776_a("foodSaturationLevel", saturationAmount + satLevel);
                foodStats.func_75112_a(nbt);
                inventory.func_70298_a(i, 1);
                ++totalEffects;
                lastSlot = i;
                break;
            }
            if (totalEffects < maxEffects) continue;
            masterRitualStone.getOwnerNetwork().causeNausea();
            break;
        }
        masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost() * totalEffects);
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 100;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addParallelRunes(components, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 4, 3, 0, EnumRuneType.EARTH);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFullStomach();
    }
}

