/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemSigilWater
extends ItemSigilBase {
    public ItemSigilWater() {
        super("water", 100);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult rayTrace;
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K && !this.isUnusable(stack) && (rayTrace = this.func_77621_a(world, player, false)) != null) {
            ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)rayTrace);
            if (ret != null) {
                return ret;
            }
            if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = rayTrace.func_178782_a();
                if (!world.func_175660_a(player, blockpos)) {
                    return super.func_77659_a(stack, world, player, hand);
                }
                if (!player.func_175151_a(blockpos.func_177972_a(rayTrace.field_178784_b), rayTrace.field_178784_b, stack)) {
                    return super.func_77659_a(stack, world, player, hand);
                }
                BlockPos blockpos1 = blockpos.func_177972_a(rayTrace.field_178784_b);
                if (!player.func_175151_a(blockpos1, rayTrace.field_178784_b, stack)) {
                    return super.func_77659_a(stack, world, player, hand);
                }
                if (this.canPlaceWater(world, blockpos1) && NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage(player, this.getLpUsed()) && this.tryPlaceWater(world, blockpos1)) {
                    return super.func_77659_a(stack, world, player, hand);
                }
            }
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || player.func_70093_af() || this.isUnusable(stack)) {
            return EnumActionResult.FAIL;
        }
        if (!world.canMineBlockBody(player, blockPos)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof IFluidHandler) {
            FluidStack fluid = new FluidStack(FluidRegistry.WATER, 1000);
            int amount = ((IFluidHandler)tile).fill(side, fluid, false);
            if (amount > 0 && NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, this.getLpUsed())) {
                ((IFluidHandler)tile).fill(side, fluid, true);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150383_bp && NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, this.getLpUsed())) {
            world.func_175656_a(blockPos, Blocks.field_150383_bp.func_176223_P().func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(3)));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean canPlaceWater(World world, BlockPos blockPos) {
        if (!world.func_175623_d(blockPos) && world.func_180495_p(blockPos).func_177230_c().func_149688_o(world.func_180495_p(blockPos)).func_76220_a()) {
            return false;
        }
        return world.func_180495_p(blockPos).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(blockPos).func_177230_c() != Blocks.field_150358_i || world.func_180495_p(blockPos).func_177230_c().func_176201_c(world.func_180495_p(blockPos)) != 0;
    }

    public boolean tryPlaceWater(World worldIn, BlockPos pos) {
        boolean notSolid;
        Material material = worldIn.func_180495_p(pos).func_177230_c().func_149688_o(worldIn.func_180495_p(pos));
        boolean bl = notSolid = !material.func_76220_a();
        if (!worldIn.func_175623_d(pos) && !notSolid) {
            return false;
        }
        if (worldIn.field_73011_w.func_177500_n()) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            worldIn.func_184148_a(null, (double)i, (double)j, (double)k, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0, new int[]{0});
            }
        } else {
            if (!worldIn.field_72995_K && notSolid && !material.func_76224_d()) {
                worldIn.func_175655_b(pos, true);
            }
            worldIn.func_180501_a(pos, Blocks.field_150358_i.func_176223_P(), 3);
        }
        return true;
    }
}

