/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.command.sub;

import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.command.CommandBloodMagic;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class SubCommandNetwork
extends CommandBase {
    public String func_71517_b() {
        return "network";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return TextHelper.localizeEffect("commands.network.usage", new Object[0]);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("help")) {
                return;
            }
            try {
                EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)args[1]);
                try {
                    ValidCommands command = ValidCommands.valueOf(args[0].toUpperCase(Locale.ENGLISH));
                    command.run((EntityPlayer)player, commandSender, args.length > 0 && args.length < 2, args);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            catch (PlayerNotFoundException e) {
                CommandBloodMagic.displayErrorString(commandSender, e.getLocalizedMessage(), new Object[0]);
            }
        } else {
            CommandBloodMagic.displayErrorString(commandSender, "commands.error.arg.missing", new Object[0]);
        }
    }

    private static enum ValidCommands {
        SYPHON("commands.network.syphon.help"){

            @Override
            public void run(EntityPlayer player, ICommandSender sender, boolean displayHelp, String ... args) {
                if (displayHelp) {
                    CommandBloodMagic.displayHelpString(sender, this.help, new Object[0]);
                    return;
                }
                if (args.length == 3) {
                    if (Utils.isInteger(args[2])) {
                        int amount = Integer.parseInt(args[2]);
                        NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, amount);
                        CommandBloodMagic.displaySuccessString(sender, "commands.network.syphon.success", amount, player.func_145748_c_().func_150254_d());
                    } else {
                        CommandBloodMagic.displayErrorString(sender, "commands.error.arg.invalid", new Object[0]);
                    }
                } else {
                    CommandBloodMagic.displayErrorString(sender, "commands.error.arg.missing", new Object[0]);
                }
            }
        }
        ,
        ADD("commands.network.add.help"){

            @Override
            public void run(EntityPlayer player, ICommandSender sender, boolean displayHelp, String ... args) {
                if (displayHelp) {
                    CommandBloodMagic.displayHelpString(sender, this.help, new Object[0]);
                    return;
                }
                SoulNetwork network = NetworkHelper.getSoulNetwork(player);
                if (args.length == 3) {
                    if (Utils.isInteger(args[2])) {
                        int amount = Integer.parseInt(args[2]);
                        int maxOrb = NetworkHelper.getMaximumForTier(network.getOrbTier());
                        CommandBloodMagic.displaySuccessString(sender, "commands.network.add.success", network.add(amount, maxOrb), player.func_145748_c_().func_150254_d());
                    } else {
                        CommandBloodMagic.displayErrorString(sender, "commands.error.arg.invalid", new Object[0]);
                    }
                } else {
                    CommandBloodMagic.displayErrorString(sender, "commands.error.arg.missing", new Object[0]);
                }
            }
        }
        ,
        SET("commands.network.set.help"){

            @Override
            public void run(EntityPlayer player, ICommandSender sender, boolean displayHelp, String ... args) {
                if (displayHelp) {
                    CommandBloodMagic.displayHelpString(sender, this.help, new Object[0]);
                    return;
                }
                SoulNetwork network = NetworkHelper.getSoulNetwork(player);
                if (args.length == 3) {
                    if (Utils.isInteger(args[2])) {
                        int amount = Integer.parseInt(args[2]);
                        network.setCurrentEssence(amount);
                        CommandBloodMagic.displaySuccessString(sender, "commands.network.set.success", player.func_145748_c_().func_150254_d(), amount);
                    } else {
                        CommandBloodMagic.displayErrorString(sender, "commands.error.arg.invalid", new Object[0]);
                    }
                } else {
                    CommandBloodMagic.displayErrorString(sender, "commands.error.arg.missing", new Object[0]);
                }
            }
        }
        ,
        GET("commands.network.get.help"){

            @Override
            public void run(EntityPlayer player, ICommandSender sender, boolean displayHelp, String ... args) {
                if (displayHelp) {
                    CommandBloodMagic.displayHelpString(sender, this.help, new Object[0]);
                    return;
                }
                SoulNetwork network = NetworkHelper.getSoulNetwork(player);
                if (args.length > 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.divination.currentEssence", network.getCurrentEssence())));
                }
            }
        }
        ,
        FILL("commands.network.fill.help"){

            @Override
            public void run(EntityPlayer player, ICommandSender sender, boolean displayHelp, String ... args) {
                if (displayHelp) {
                    CommandBloodMagic.displayHelpString(sender, this.help, Integer.MAX_VALUE);
                    return;
                }
                SoulNetwork network = NetworkHelper.getSoulNetwork(player);
                if (args.length > 1) {
                    network.setCurrentEssence(Integer.MAX_VALUE);
                    CommandBloodMagic.displaySuccessString(sender, "commands.network.fill.success", player.func_145748_c_().func_150254_d());
                }
            }
        }
        ,
        CAP("commands.network.cap.help"){

            @Override
            public void run(EntityPlayer player, ICommandSender sender, boolean displayHelp, String ... args) {
                if (displayHelp) {
                    CommandBloodMagic.displayHelpString(sender, this.help, new Object[0]);
                    return;
                }
                SoulNetwork network = NetworkHelper.getSoulNetwork(player);
                if (args.length > 1) {
                    int maxOrb = NetworkHelper.getMaximumForTier(network.getOrbTier());
                    network.setCurrentEssence(maxOrb);
                    CommandBloodMagic.displaySuccessString(sender, "commands.network.cap.success", player.func_145748_c_().func_150254_d());
                }
            }
        };

        public String help;

        private ValidCommands(String help) {
            this.help = help;
        }

        public abstract void run(EntityPlayer var1, ICommandSender var2, boolean var3, String ... var4);
    }
}

