/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.config.network;

import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageClientOptions
implements IMessage,
IMessageHandler<MessageClientOptions, IMessage> {
    private Map<String, Integer> optionsToSend;
    private String playerUUID;

    public MessageClientOptions() {
    }

    public MessageClientOptions(Map<String, Integer> options, EntityPlayer player) {
        this.optionsToSend = options;
        this.playerUUID = player.func_110124_au().toString();
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int size = buf.readInt();
        HashMap<String, Integer> options = new HashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            options.put(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readInt());
        }
        this.optionsToSend = options;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID);
        buf.writeInt(this.optionsToSend.size());
        this.optionsToSend.forEach((s, i) -> {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
            buf.writeInt(i.intValue());
        });
    }

    public IMessage onMessage(MessageClientOptions message, MessageContext ctx) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
            IClientOptsCapability cap = (IClientOptsCapability)ctx.getServerHandler().field_147369_b.getCapability(TOPAddons.OPTS_CAP, null);
            cap.setAll(message.optionsToSend);
        });
        return null;
    }
}

