/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.tinkers_addons.modifiers;

import com.oitsjustjose.tinkers_addons.TinkersAddons;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ModAutoRepair
extends Modifier {
    public ModAutoRepair() {
        super("auto-repair");
        this.addAspects(new ModifierAspect[]{new ModifierAspect.LevelAspect((IModifier)this, 5), new ModifierAspect.DataAspect((IModifier)this, 2925569), ModifierAspect.freeModifier});
        this.addItem(new ItemStack(TinkersAddons.modItems.materials, 1, 0), 1, 1);
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return super.getTooltip(modifierTag, detailed);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onUpdate(PlayerEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ArrayList<ItemStack> tinkersTools = new ArrayList<ItemStack>();
        for (ItemStack iterStack : player.field_71071_by.field_70462_a) {
            if (iterStack == null || !(iterStack.func_77973_b() instanceof ToolCore)) continue;
            tinkersTools.add(iterStack);
        }
        if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof ToolCore) {
            tinkersTools.add(player.func_184592_cb());
        }
        for (ItemStack iterStack : tinkersTools) {
            int autoRepairLevel = 0;
            NBTTagCompound tag = TagUtil.getToolTag((NBTTagCompound)iterStack.func_77978_p());
            NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)iterStack);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound currTag;
                if (!(tagList.func_179238_g(i) instanceof NBTTagCompound) || !(currTag = (NBTTagCompound)tagList.func_179238_g(i)).func_74779_i("identifier").contains("auto-repair")) continue;
                autoRepairLevel = currTag.func_74762_e("level");
            }
            long lastRepairTime = tag.func_74763_f("Last Auto-Repair");
            if (autoRepairLevel <= 0 || System.currentTimeMillis() - lastRepairTime < (long)this.getRepairCooldown(player) || player.field_82175_bq) continue;
            ToolHelper.healTool((ItemStack)iterStack, (int)autoRepairLevel, (EntityLivingBase)player);
            tag.func_74772_a("Last Auto-Repair", System.currentTimeMillis());
        }
    }

    int getRepairCooldown(EntityPlayer player) {
        World world = player.func_130014_f_();
        int rand = world.field_73012_v.nextInt(999);
        if (player.field_71093_bK == -1) {
            return 10000 + rand;
        }
        if (world.func_175678_i(player.func_180425_c()) && !world.func_72896_J() && world.func_72820_D() >= 0L && world.func_72820_D() <= 13000L) {
            return 12500 + rand;
        }
        return 15000 + rand;
    }
}

