/*
 * Decompiled with CFR 0.152.
 */
package rangedpumps.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import rangedpumps.RangedPumps;
import rangedpumps.tile.EnumPumpState;
import rangedpumps.tile.TilePump;

public class BlockPump
extends Block {
    public BlockPump() {
        super(Material.field_151576_e);
        this.setRegistryName("rangedpumps", "pump");
        this.func_149711_c(3.8f);
        this.func_149647_a(RangedPumps.TAB);
    }

    public String func_149739_a() {
        return "block.rangedpumps:pump";
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TilePump) {
            TilePump pump = (TilePump)tile;
            ITextComponent message = EnumPumpState.getMessage(pump);
            if (message != null) {
                player.func_146105_b(message);
            }
            if (pump.getTank().getFluidAmount() == 0) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("block.rangedpumps:pump.state_empty", new Object[]{pump.getEnergy().getEnergyStored(), pump.getEnergy().getMaxEnergyStored()}));
            } else {
                String name = pump.getTank().getFluid().getUnlocalizedName();
                Object nameComponent = name.equals("fluid.tile.water") ? new TextComponentString("water") : (name.equals("fluid.tile.lava") ? new TextComponentString("lava") : new TextComponentTranslation(name, new Object[0]));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("block.rangedpumps:pump.state", new Object[]{pump.getTank().getFluidAmount(), nameComponent, pump.getEnergy().getEnergyStored(), pump.getEnergy().getMaxEnergyStored()}));
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePump();
    }
}

