/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter.chests;

import cubex2.mods.chesttransporter.ChestTransporter;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TransportableChest {
    protected final Block chestBlock;
    protected final int chestMeta;
    protected final int transporterDV;
    protected final String iconName;

    public TransportableChest(Block chestBlock, int chestMeta, int transporterDV, String iconName) {
        this.chestBlock = chestBlock;
        this.chestMeta = chestMeta;
        this.transporterDV = transporterDV;
        this.iconName = iconName;
        this.addModelLocations();
    }

    public boolean isUsableWith(ItemStack stack) {
        return true;
    }

    public boolean copyTileEntity() {
        return false;
    }

    public Block getChestBlock() {
        return this.chestBlock;
    }

    public int getChestMetadata() {
        return this.chestMeta;
    }

    public int getTransporterDV() {
        return this.transporterDV;
    }

    public ItemStack createChestStack(ItemStack transporter) {
        if (this.getChestMetadata() == -1) {
            return new ItemStack(this.getChestBlock());
        }
        return new ItemStack(this.getChestBlock(), 1, this.getChestMetadata());
    }

    public void preRemoveChest(ItemStack transporter, TileEntity chestTE) {
    }

    public void preDestroyTransporter(EntityLivingBase living, ItemStack transporter, TileEntity chestTE) {
    }

    public void modifyTileCompound(EntityLivingBase living, NBTTagCompound nbt) {
    }

    public String getModelName(ItemStack stack) {
        return this.iconName;
    }

    public void addModelLocations() {
        ChestTransporter.proxy.addModelLocation(this.iconName);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
    }

    public boolean canGrab(TileEntity chestTE) {
        return true;
    }
}

