/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.forgefixes;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelSimpleProperties;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.forgefixes.OBJCustomData;

public class OBJModel
implements IRetexturableModel,
IModelCustomData,
IModelSimpleProperties {
    public static final StandardToStringStyle STYLE = new StandardToStringStyle();
    private MaterialLibrary matLib;
    private OBJCustomData customData = null;
    private final ResourceLocation modelLocation;
    private final boolean gui3d;
    private final boolean smooth;

    public OBJModel(MaterialLibrary matLib, ResourceLocation modelLocation, float[][] parsedUVBounds) {
        this(matLib, modelLocation, new OBJCustomData(parsedUVBounds), true, true);
    }

    public OBJModel(MaterialLibrary matLib, ResourceLocation modelLocation, float[][] parsedUVBounds, boolean gui3d, boolean smooth) {
        this(matLib, modelLocation, new OBJCustomData(parsedUVBounds), gui3d, smooth);
    }

    public OBJModel(MaterialLibrary matLib, ResourceLocation modelLocation, OBJCustomData customData) {
        this(matLib, modelLocation, customData, true, true);
    }

    public OBJModel(MaterialLibrary matLib, ResourceLocation modelLocation, OBJCustomData customData, boolean gui3d, boolean smooth) {
        this.matLib = matLib;
        this.modelLocation = modelLocation;
        this.customData = customData;
        this.customData.setGroupNameList(this.matLib.getGroupNames());
        this.gui3d = gui3d;
        this.smooth = smooth;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        Iterator materialIterator = this.matLib.materials.values().iterator();
        ArrayList textures = Lists.newArrayList();
        while (materialIterator.hasNext()) {
            Material mat = (Material)materialIterator.next();
            ResourceLocation textureLoc = new ResourceLocation(mat.getTexture().getPath());
            if (textures.contains(textureLoc) || mat.isWhite()) continue;
            textures.add(textureLoc);
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ModelLoader.White.LOCATION.toString(), (Object)ModelLoader.White.INSTANCE);
        TextureAtlasSprite missing = (TextureAtlasSprite)bakedTextureGetter.apply((Object)new ResourceLocation("missingno"));
        for (Map.Entry e : this.matLib.materials.entrySet()) {
            if (((Material)e.getValue()).getTexture().getTextureLocation().func_110623_a().startsWith("#")) {
                FMLLog.severe((String)"OBJLoader: Unresolved texture '%s' for obj model '%s'", (Object[])new Object[]{((Material)e.getValue()).getTexture().getTextureLocation().func_110623_a(), this.modelLocation});
                builder.put(e.getKey(), (Object)missing);
                continue;
            }
            builder.put(e.getKey(), bakedTextureGetter.apply((Object)((Material)e.getValue()).getTexture().getTextureLocation()));
        }
        builder.put((Object)"missingno", (Object)missing);
        boolean allFalse = this.customData.allProcessUVValuesFalse();
        boolean outOfBounds = this.customData.hasUVsOutOfBounds();
        if (allFalse && outOfBounds) {
            FMLLog.severe((String)"OBJLoader: Model '%s' has UVs ('vt') out of bounds 0..1! It may not render as expected!", (Object[])new Object[]{this.modelLocation});
        }
        return new OBJBakedModel(this, state, format, (ImmutableMap<String, TextureAtlasSprite>)builder.build());
    }

    public MaterialLibrary getMatLib() {
        return this.matLib;
    }

    public OBJCustomData getCustomData() {
        return this.customData;
    }

    public ResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    public OBJModel process(ImmutableMap<String, String> customData) {
        OBJCustomData data;
        if (this.customData != null) {
            data = this.customData.duplicate();
            data.process(customData);
        } else {
            data = new OBJCustomData(customData);
        }
        OBJModel ret = new OBJModel(this.matLib, this.modelLocation, data);
        return ret;
    }

    public OBJModel retexture(ImmutableMap<String, String> textures) {
        OBJModel ret = new OBJModel(this.matLib.makeLibWithReplacements(textures), this.modelLocation, this.customData, this.gui3d, this.smooth);
        return ret;
    }

    public IModelState getDefaultState() {
        return new OBJState(null, (IModelState)TRSRTransformation.identity());
    }

    public OBJModel smoothLighting(boolean value) {
        if (value == this.smooth) {
            return this;
        }
        return new OBJModel(this.matLib, this.modelLocation, this.customData, this.gui3d, value);
    }

    public OBJModel gui3d(boolean value) {
        if (value == this.gui3d) {
            return this;
        }
        return new OBJModel(this.matLib, this.modelLocation, this.customData, value, this.smooth);
    }

    public String toString() {
        return this.modelLocation.toString();
    }

    static {
        STYLE.setUseShortClassName(true);
        STYLE.setUseIdentityHashCode(false);
        STYLE.setContentStart(String.format(":[{%n    ", new Object[0]));
        STYLE.setContentEnd(String.format("%n}]%n", new Object[0]));
        STYLE.setFieldNameValueSeparator(": ");
        STYLE.setFieldSeparator(String.format(",%n    ", new Object[0]));
        STYLE.setNullText("---");
    }

    public class OBJBakedModel
    implements IPerspectiveAwareModel {
        private final OBJModel model;
        private final VertexFormat format;
        private final boolean gui3d;
        private final boolean smooth;
        private IModelState state;
        private Set<BakedQuad> quads;
        private ImmutableMap<String, TextureAtlasSprite> textures;
        private TextureAtlasSprite sprite = ModelLoader.White.INSTANCE;
        private Map<Group, Boolean> visibilityMap = Maps.newHashMap();
        private Map<String, Vector4f> colorMap = Maps.newHashMap();
        private Map<String, Material> materials;

        public OBJBakedModel(OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures) {
            this(model, state, format, textures, null);
        }

        public OBJBakedModel(OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, Map<Group, Boolean> visibilityMap) {
            this.model = model;
            this.gui3d = this.model.gui3d;
            this.smooth = this.model.smooth;
            this.materials = Maps.newHashMap((Map)this.model.getMatLib().materials);
            this.state = state;
            this.format = format;
            this.textures = textures;
            if (visibilityMap == null) {
                this.fillMap();
            } else {
                this.visibilityMap = visibilityMap;
            }
        }

        private void fillMap() {
            for (Group g : this.model.getMatLib().getGroups().values()) {
                this.visibilityMap.put(g, true);
            }
        }

        private void bakeFaces(Set<Face> faces, Optional<TRSRTransformation> transform) {
            for (Group g : this.model.getMatLib().getGroups().values()) {
                faces.addAll(g.applyTransform(transform, this.model, this.materials));
            }
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            OBJState s;
            IExtendedBlockState exState;
            if (side != null) {
                return ImmutableList.of();
            }
            IModelState modelState = this.state;
            if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains((Object)OBJProperty.INSTANCE) && (s = (OBJState)exState.getValue((IUnlistedProperty)OBJProperty.INSTANCE)) != null) {
                modelState = OBJState.copyFrom(s);
                try {
                    ImmutableList<String> showenGroups = s.getShownConfigs();
                    if (showenGroups != null) {
                        for (Object entry : showenGroups) {
                            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                            map.put((String)entry, true);
                            this.model.getCustomData().getConfigHandler().addConfig(new OBJCustomData.GroupConfig((String)entry, map));
                        }
                    }
                }
                catch (Throwable showenGroups) {
                    // empty catch block
                }
            }
            if (this.quads == null || !modelState.equals(this.state)) {
                boolean applyToAll = true;
                this.quads = Collections.synchronizedSet(Sets.newLinkedHashSet());
                Set<Face> faces = Collections.synchronizedSet(Sets.newLinkedHashSet());
                Optional transform = modelState.apply(Optional.absent());
                if (modelState instanceof OBJState) {
                    OBJState s2 = (OBJState)modelState;
                    this.colorMap = s2.getMaterialColorMap();
                    if (this.materials != null) {
                        for (Map.Entry e : this.colorMap.entrySet()) {
                            if (!this.materials.containsKey(e.getKey())) continue;
                            this.materials.get(e.getKey()).setColor((Vector4f)e.getValue());
                        }
                    }
                    OBJCustomData.GroupConfig activeConfig = this.model.getCustomData().getConfigHandler().getCombinedConfig((List<String>)s2.getShownConfigs(), s2.getIgnoreHidden());
                    if (!s2.shouldHideAllConfigs() && activeConfig != null) {
                        applyToAll = false;
                        for (Map.Entry e : activeConfig.getVisMap().entrySet()) {
                            if (!((Boolean)e.getValue()).booleanValue()) continue;
                            try {
                                faces.addAll(this.model.getMatLib().getGroups().get(e.getKey()).applyTransform((Optional<TRSRTransformation>)transform, this.model, this.materials));
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        boolean bl = applyToAll = !s2.shouldHideAllConfigs() || s2.shouldShowAllConfigs();
                    }
                }
                if (applyToAll) {
                    this.bakeFaces(faces, (Optional<TRSRTransformation>)transform);
                }
                for (Face f : faces) {
                    this.sprite = this.materials.get(f.getMaterialName()).isWhite() ? ModelLoader.White.INSTANCE : (TextureAtlasSprite)this.textures.get((Object)f.getMaterialName());
                    Vector3f[] defUVs = MaterialLibrary.getDefaultUVs((Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)false));
                    Vector3f faceNormal = f.getNormal();
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
                    builder.setContractUVs(true);
                    builder.setQuadOrientation(EnumFacing.func_176737_a((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z));
                    builder.setTexture(this.sprite);
                    this.putVertexData(builder, f.verts[0], defUVs[0], this.sprite);
                    this.putVertexData(builder, f.verts[1], defUVs[1], this.sprite);
                    this.putVertexData(builder, f.verts[2], defUVs[2], this.sprite);
                    this.putVertexData(builder, f.verts[3], defUVs[3], this.sprite);
                    this.quads.add((BakedQuad)builder.build());
                }
            }
            List<BakedQuad> quadList = Collections.synchronizedList(Lists.newArrayList(this.quads));
            return quadList;
        }

        private final void putVertexData(UnpackedBakedQuad.Builder builder, Vertex v, Vector3f defUV, TextureAtlasSprite sprite) {
            block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        builder.put(e, new float[]{v.getPos().x, v.getPos().y, v.getPos().z, v.getPos().w});
                        continue block6;
                    }
                    case COLOR: {
                        builder.put(e, new float[]{v.getMaterial().getColor().x, v.getMaterial().getColor().y, v.getMaterial().getColor().z, v.getMaterial().getColor().w});
                        continue block6;
                    }
                    case UV: {
                        if (((OBJModel)this.model).customData.useFullAtlas) {
                            builder.put(e, new float[]{defUV.x, defUV.y, 0.0f, 1.0f});
                            continue block6;
                        }
                        if (sprite.equals(ModelLoader.White.INSTANCE)) {
                            builder.put(e, new float[]{sprite.func_94214_a((double)(defUV.x * 16.0f)), sprite.func_94207_b((double)(defUV.y * 16.0f)), 0.0f, 1.0f});
                            continue block6;
                        }
                        builder.put(e, new float[]{sprite.func_94214_a((double)(v.getTextureCoordinate().x * 16.0f)), sprite.func_94207_b((double)(v.getTextureCoordinate().y * 16.0f)), 0.0f, 1.0f});
                        continue block6;
                    }
                    case NORMAL: {
                        builder.put(e, new float[]{v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f});
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return this.smooth;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.sprite;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public OBJModel getModel() {
            return this.model;
        }

        public IModelState getState() {
            return this.state;
        }

        public OBJBakedModel getBakedModel() {
            return new OBJBakedModel(this.model, this.state, this.format, this.textures);
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.state, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public String toString() {
            return this.model.modelLocation.toString();
        }
    }

    public static enum OBJProperty implements IUnlistedProperty<OBJState>
    {
        INSTANCE;


        public String getName() {
            return "OBJPropery";
        }

        public boolean isValid(OBJState value) {
            return value instanceof OBJState;
        }

        public Class<OBJState> getType() {
            return OBJState.class;
        }

        public String valueToString(OBJState value) {
            return value.toString();
        }
    }

    public static class OBJState
    implements IModelState {
        private List<String> shownConfigs = null;
        private Map<String, Vector4f> materialColorMap = Maps.newHashMap();
        private boolean ignoreHidden = false;
        private IModelState parent;

        public OBJState() {
        }

        public OBJState(IModelState parent) {
            this.parent = parent;
        }

        public OBJState(List<String> activeConfigs) {
            this.shownConfigs = activeConfigs;
        }

        public OBJState(List<String> activeConfigs, IModelState parent) {
            this.shownConfigs = activeConfigs;
            this.parent = parent;
        }

        public static OBJState copyFrom(OBJState state) {
            OBJState retState = new OBJState();
            retState.shownConfigs = state.shownConfigs != null ? Lists.newArrayList(state.shownConfigs) : null;
            retState.materialColorMap = state.materialColorMap != null ? Maps.newHashMap(state.materialColorMap) : Maps.newHashMap();
            retState.ignoreHidden = state.ignoreHidden;
            retState.parent = state.parent;
            return retState;
        }

        public OBJState setIgnoreHidden(boolean ignoreHidden) {
            this.ignoreHidden = ignoreHidden;
            return this;
        }

        public boolean getIgnoreHidden() {
            return this.ignoreHidden;
        }

        public OBJState showConfig(String configName) {
            if (configName != null) {
                if (this.shownConfigs == null) {
                    this.shownConfigs = Lists.newArrayList();
                }
                this.shownConfigs.add(configName);
            }
            return this;
        }

        public OBJState showConfigs(List<String> configNames, boolean ignoreHidden) {
            if (this.shownConfigs == null) {
                this.shownConfigs = Lists.newArrayList();
            }
            this.shownConfigs.addAll(configNames);
            this.ignoreHidden = ignoreHidden;
            return this;
        }

        public ImmutableList<String> getShownConfigs() {
            return this.shownConfigs == null ? null : ImmutableList.copyOf(this.shownConfigs);
        }

        public OBJState setShowAllConfigs() {
            this.shownConfigs = null;
            return this;
        }

        public OBJState setHideAllConfigs() {
            this.shownConfigs = Lists.newArrayList();
            return this;
        }

        public boolean shouldShowAllConfigs() {
            return this.shownConfigs == null;
        }

        public boolean shouldHideAllConfigs() {
            return this.shownConfigs != null && this.shownConfigs.isEmpty();
        }

        public OBJState setParent(IModelState parent) {
            this.parent = parent;
            return this;
        }

        public IModelState getParent() {
            return this.parent;
        }

        public static IModelState getParent(IModelState parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof OBJState) {
                return ((OBJState)parent).parent;
            }
            return parent;
        }

        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            if (this.parent != null) {
                return this.parent.apply(part);
            }
            return Optional.absent();
        }

        public OBJState setMaterialColor(String materialName, int color) {
            float a = (color >> 24 & 0xFF) / 255;
            float r = (color >> 16 & 0xFF) / 255;
            float g = (color >> 8 & 0xFF) / 255;
            float b = (color & 0xFF) / 255;
            return this.setMaterialColor(materialName, new Vector4f(r, g, b, a));
        }

        public OBJState setMaterialColor(String materialName, Vector4f color) {
            this.materialColorMap.put(materialName, color);
            return this;
        }

        public Map<String, Vector4f> getMaterialColorMap() {
            if (this.materialColorMap == null) {
                this.materialColorMap = Maps.newHashMap();
            }
            return this.materialColorMap;
        }

        public String toString() {
            ToStringBuilder build = new ToStringBuilder((Object)this, (ToStringStyle)STYLE);
            build.append("Parent", (Object)this.parent);
            build.append("Material Color Map", this.materialColorMap, false);
            build.append("Shown Configurations", this.shownConfigs, false);
            build.append("Ignore Hidden", this.ignoreHidden);
            return build.toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.shownConfigs, this.parent, this.materialColorMap, this.ignoreHidden});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OBJState other = (OBJState)obj;
            return Objects.equal(this.shownConfigs, other.shownConfigs) && Objects.equal((Object)this.parent, (Object)other.parent) && Objects.equal(this.materialColorMap, other.materialColorMap) && Objects.equal((Object)this.ignoreHidden, (Object)other.ignoreHidden);
        }
    }

    public static class Group
    implements IModelPart {
        public static final String DEFAULT_NAME = "OBJModel.Default.Group.Name";
        public static final String ALL = "OBJModel.Group.All.Key";
        public static final String ALL_EXCEPT = "OBJModel.Group.All.Except.Key";
        private String name = "OBJModel.Default.Group.Name";
        private LinkedHashSet<Face> faces = Sets.newLinkedHashSet();

        public Group(String name, LinkedHashSet<Face> faces) {
            this.name = name != null ? name : DEFAULT_NAME;
            this.faces = faces == null ? Sets.newLinkedHashSet() : faces;
        }

        public LinkedHashSet<Face> applyTransform(Optional<TRSRTransformation> transform, OBJModel model, Map<String, Material> materials) {
            LinkedHashSet faceSet = Sets.newLinkedHashSet();
            for (Face f : this.faces) {
                faceSet.add(f.bake((TRSRTransformation)transform.or((Object)TRSRTransformation.identity()), model.customData, materials));
            }
            return faceSet;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasFaces() {
            return this.faces != null && !this.faces.isEmpty();
        }

        public LinkedHashSet<Face> getFaces() {
            return Sets.newLinkedHashSet(this.faces);
        }

        protected void setFaces(LinkedHashSet<Face> faces) {
            this.faces = faces;
        }

        protected void addFace(Face face) {
            this.faces.add(face);
        }

        protected void addFaces(List<Face> faces) {
            this.faces.addAll(faces);
        }

        public String toString() {
            ToStringBuilder build = new ToStringBuilder((Object)this, (ToStringStyle)STYLE);
            build.append("Name", (Object)this.name);
            build.append("Faces", this.faces, false);
            return build.toString();
        }
    }

    public static class Vertex {
        protected Vector4f position;
        protected Vector3f normal;
        protected Vector3f texCoord;
        protected Material material = new Material();

        public Vertex(Vector4f position, Material material) {
            this.position = position;
            this.material = material;
        }

        public static Vertex copyFrom(Vertex vert) {
            Vertex retVert = new Vertex(vert.getPos(), vert.getMaterial());
            retVert.setTextureCoordinate(vert.getTextureCoordinate());
            retVert.setNormal(vert.getNormal());
            return retVert;
        }

        protected void setPos(Vector4f position) {
            this.position = position;
        }

        public Vector4f getPos() {
            return new Vector4f(this.position);
        }

        public Vector3f getPos3() {
            return new Vector3f(this.position.x, this.position.y, this.position.z);
        }

        public boolean hasNormal() {
            return this.normal != null;
        }

        protected void setNormal(Vector3f normal) {
            this.normal = normal;
        }

        public Vector3f getNormal() {
            return this.normal == null ? null : new Vector3f(this.normal);
        }

        public boolean hasTextureCoordinate() {
            return this.texCoord != null;
        }

        protected void setTextureCoordinate(Vector3f texCoord) {
            this.texCoord = texCoord;
        }

        public Vector3f getTextureCoordinate() {
            return this.texCoord == null ? null : new Vector3f(this.texCoord);
        }

        protected void setMaterial(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return Material.copyFrom(this.material);
        }

        public String toString() {
            ToStringBuilder build = new ToStringBuilder((Object)this, (ToStringStyle)STYLE);
            build.append("Position", (Object)this.position);
            build.append("Normal", (Object)this.normal);
            build.append("Texture Coordinate", (Object)this.texCoord);
            build.append("Material", (Object)this.material);
            return build.toString();
        }
    }

    public static class Face {
        private Vertex[] verts = new Vertex[4];
        private String materialName = "OBJModel.Default.Texture.Name";
        private boolean isTri = false;

        public Face(Vertex[] verts) {
            this(verts, "OBJModel.Default.Texture.Name");
        }

        public Face(Vertex[] verts, String materialName) {
            this.verts = verts != null && verts.length > 2 ? verts : null;
            this.setMaterialName(materialName);
            this.checkData();
        }

        public Face(Vertex[] verts, String materialName, boolean isTri) {
            this.verts = verts != null && verts.length > 2 ? verts : null;
            this.setMaterialName(materialName);
            this.isTri = isTri;
        }

        private void checkData() {
            if (this.verts != null && this.verts.length == 3) {
                this.isTri = true;
                this.verts = new Vertex[]{this.verts[0], this.verts[1], this.verts[2], this.verts[2]};
            }
        }

        protected void setMaterialName(String materialName) {
            this.materialName = materialName != null && !materialName.isEmpty() ? materialName : this.materialName;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public boolean isTriangle() {
            return this.isTri;
        }

        protected boolean setVertices(Vertex[] verts) {
            if (verts == null) {
                return false;
            }
            this.verts = verts;
            this.checkData();
            return true;
        }

        public Vertex[] getVertices() {
            return this.verts;
        }

        private static Vertex[] ensureTextureCoordinates(Vertex[] verts, boolean isTri) {
            Vector3f[] defUVs = MaterialLibrary.getDefaultUVs((Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)false));
            Vertex[] retVerts = new Vertex[verts.length];
            for (int i = 0; i < verts.length; ++i) {
                retVerts[i] = Vertex.copyFrom(verts[i]);
                if (retVerts[i].hasTextureCoordinate()) continue;
                retVerts[i].setTextureCoordinate(defUVs[isTri && i == 3 ? 2 : i]);
            }
            return retVerts;
        }

        public static Vertex[] normalizeUVs(Vertex[] verts, Pair<Boolean, Boolean> flags, float[][] bounds) {
            Vertex[] retVerts = new Vertex[verts.length];
            for (int i = 0; i < verts.length; ++i) {
                retVerts[i] = Vertex.copyFrom(verts[i]);
                if (((Boolean)flags.getLeft()).booleanValue()) {
                    retVerts[i].texCoord.x = (retVerts[i].texCoord.x - bounds[0][0]) / (bounds[1][0] - bounds[0][0]);
                }
                if (!((Boolean)flags.getRight()).booleanValue()) continue;
                retVerts[i].texCoord.y = (retVerts[i].texCoord.y - bounds[0][1]) / (bounds[1][1] - bounds[0][1]);
            }
            return retVerts;
        }

        public static Vertex[] unitizeUVs(Vertex[] verts, Pair<Boolean, Boolean> flags, boolean isTri) {
            Vector3f[] defUVs = MaterialLibrary.getDefaultUVs((Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)false));
            Vertex[] retVerts = new Vertex[verts.length];
            for (int i = 0; i < verts.length; ++i) {
                retVerts[i] = Vertex.copyFrom(verts[i]);
                if (((Boolean)flags.getLeft()).booleanValue()) {
                    retVerts[i].texCoord.x = defUVs[isTri && i == 3 ? 2 : i].x;
                }
                if (!((Boolean)flags.getRight()).booleanValue()) continue;
                retVerts[i].texCoord.y = defUVs[isTri && i == 3 ? 2 : i].y;
            }
            return retVerts;
        }

        public static Vertex[] flipUVs(Vertex[] verts, Pair<Boolean, Boolean> flags) {
            Vertex[] retVerts = new Vertex[verts.length];
            for (int i = 0; i < verts.length; ++i) {
                retVerts[i] = Vertex.copyFrom(verts[i]);
                if (((Boolean)flags.getLeft()).booleanValue()) {
                    retVerts[i].texCoord.x = 1.0f - retVerts[i].texCoord.x;
                }
                if (!((Boolean)flags.getRight()).booleanValue()) continue;
                retVerts[i].texCoord.y = 1.0f - retVerts[i].texCoord.y;
            }
            return retVerts;
        }

        public Face bake(TRSRTransformation transform, OBJCustomData customData, Map<String, Material> materials) {
            int i;
            Vertex[] vertices = new Vertex[this.verts.length];
            for (int i2 = 0; i2 < this.verts.length; ++i2) {
                vertices[i2] = Vertex.copyFrom(this.verts[i2]);
                if (materials == null || vertices[i2].getMaterial().equals(materials.get(vertices[i2].getMaterial().getName()))) continue;
                vertices[i2].setMaterial(materials.get(vertices[i2].getMaterial().getName()));
            }
            vertices = Face.ensureTextureCoordinates(vertices, this.isTri);
            if (customData != null && customData.hasProcessed) {
                for (Map.Entry<OBJCustomData.Keys, Pair<Boolean, Boolean>> e : customData.processUVData.entrySet()) {
                    switch (e.getKey()) {
                        case NORMALIZE_UVS: {
                            vertices = Face.normalizeUVs(vertices, e.getValue(), customData.parsedUVBounds);
                            break;
                        }
                        case UNITIZE_UVS: {
                            vertices = Face.unitizeUVs(vertices, e.getValue(), this.isTri);
                            break;
                        }
                        case FLIP_UVS: {
                            vertices = Face.flipUVs(vertices, e.getValue());
                            break;
                        }
                    }
                }
            }
            Matrix4f m = transform.getMatrix();
            Matrix3f mn = null;
            boolean useFaceNormal = false;
            for (i = 0; i < this.verts.length; ++i) {
                Vector4f pos = vertices[i].getPos();
                Vector4f newPos = new Vector4f();
                m.transform((Tuple4f)pos, (Tuple4f)newPos);
                vertices[i].setPos(newPos);
                if (vertices[i].hasNormal()) continue;
                useFaceNormal = true;
            }
            if (useFaceNormal) {
                this.useFaceNormal(vertices);
            } else {
                for (i = 0; i < this.verts.length; ++i) {
                    if (mn == null) {
                        mn = new Matrix3f();
                        m.getRotationScale(mn);
                        mn.invert();
                        mn.transpose();
                    }
                    Vector3f normal = vertices[i].getNormal();
                    Vector3f newNormal = new Vector3f();
                    mn.transform((Tuple3f)normal, (Tuple3f)newNormal);
                    newNormal.normalize();
                    vertices[i].setNormal(newNormal);
                }
            }
            return new Face(vertices, this.materialName, this.isTri);
        }

        private void useFaceNormal(Vertex[] verts) {
            Vector3f a = verts[2].getPos3();
            a.sub((Tuple3f)verts[0].getPos3());
            Vector3f b = verts[3].getPos3();
            b.sub((Tuple3f)verts[1].getPos3());
            a.cross(a, b);
            a.normalize();
            for (int i = 0; i < verts.length; ++i) {
                verts[i].setNormal(a);
            }
        }

        public Vector3f getNormal() {
            Vector3f a = this.verts[2].getPos3();
            a.sub((Tuple3f)this.verts[0].getPos3());
            Vector3f b = this.verts[3].getPos3();
            b.sub((Tuple3f)this.verts[1].getPos3());
            a.cross(a, b);
            a.normalize();
            return new Vector3f(a);
        }

        public String toString() {
            ToStringBuilder build = new ToStringBuilder((Object)this, (ToStringStyle)STYLE);
            build.append("Is Triangle", this.isTri);
            build.append("Vertices", (Object[])this.verts, false);
            build.append("Material Name", (Object)this.materialName);
            return build.toString();
        }
    }

    public static class Texture {
        public static Texture WHITE = new Texture("builtin/white", new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        private String path;
        private Vector2f position;
        private Vector2f scale;
        private float rotation;

        public Texture(String path) {
            this(path, new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        }

        public Texture(String path, Vector2f position, Vector2f scale, float rotation) {
            this.path = path;
            this.position = position;
            this.scale = scale;
            this.rotation = rotation;
        }

        protected static Texture copyFrom(Texture texture) {
            return new Texture(texture.path, texture.position, texture.scale, texture.rotation);
        }

        public ResourceLocation getTextureLocation() {
            return new ResourceLocation(this.path);
        }

        protected void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        protected void setPosition(Vector2f position) {
            this.position = position;
        }

        public Vector2f getPosition() {
            return this.position;
        }

        protected void setScale(Vector2f scale) {
            this.scale = scale;
        }

        public Vector2f getScale() {
            return this.scale;
        }

        protected void setRotation(float rotation) {
            this.rotation = rotation;
        }

        public float getRotation() {
            return this.rotation;
        }

        public String toString() {
            ToStringBuilder build = new ToStringBuilder((Object)this, (ToStringStyle)STYLE);
            build.append("Location", (Object)this.path);
            build.append("Position", (Object)this.position);
            build.append("Scale", (Object)this.scale);
            build.append("Rotation", this.rotation);
            return build.toString();
        }
    }

    public static class Material {
        public static final String WHITE_NAME = "OBJModel.White.Texture.Name";
        public static final String DEFAULT_NAME = "OBJModel.Default.Texture.Name";
        private Vector4f color;
        private Texture texture = Texture.WHITE;
        private String name = "OBJModel.Default.Texture.Name";

        public Material() {
            this(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
        }

        public Material(Vector4f color) {
            this(color, Texture.WHITE, WHITE_NAME);
        }

        public Material(Texture texture) {
            this(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), texture, DEFAULT_NAME);
        }

        public Material(Vector4f color, Texture texture, String name) {
            this.color = color;
            this.texture = texture;
            this.name = name != null ? name : DEFAULT_NAME;
        }

        protected static Material copyFrom(Material material) {
            return new Material(material.color, material.texture, material.name);
        }

        protected void setName(String name) {
            this.name = name != null ? name : DEFAULT_NAME;
        }

        public String getName() {
            return this.name;
        }

        protected void setColor(Vector4f color) {
            this.color = color;
        }

        public Vector4f getColor() {
            return this.color;
        }

        protected void setTexture(Texture texture) {
            this.texture = texture;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public boolean isWhite() {
            return this.texture.equals(Texture.WHITE);
        }

        public String toString() {
            ToStringBuilder build = new ToStringBuilder((Object)this, (ToStringStyle)STYLE);
            build.append("Name", (Object)this.name);
            build.appendToString(this.texture.toString());
            build.append("Color", (Object)this.color);
            build.append("Is White", this.isWhite());
            return build.toString();
        }
    }

    public static class MaterialLibrary {
        private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
        private Set<String> unknownMaterialCommands = Sets.newHashSet();
        private Map<String, Material> materials = Maps.newHashMap();
        private Map<String, Group> groups = Maps.newHashMap();
        private InputStreamReader mtlStream;
        private BufferedReader mtlReader;

        public MaterialLibrary() {
            this.groups.put("OBJModel.Default.Group.Name", new Group("OBJModel.Default.Group.Name", null));
            this.initMaterialMap();
        }

        protected static MaterialLibrary copyFrom(MaterialLibrary matLib) {
            MaterialLibrary ret = new MaterialLibrary();
            ret.groups = matLib.groups;
            ret.materials = matLib.materials;
            ret.mtlReader = matLib.mtlReader;
            ret.mtlStream = matLib.mtlStream;
            ret.unknownMaterialCommands = matLib.unknownMaterialCommands;
            return ret;
        }

        private void initMaterialMap() {
            this.materials.put("OBJModel.Default.Texture.Name", new Material(Texture.WHITE));
            this.materials.put("OBJModel.White.Texture.Name", new Material());
        }

        public MaterialLibrary makeLibWithReplacements(ImmutableMap<String, String> replacements) {
            HashMap mats = Maps.newHashMap();
            for (Map.Entry<String, Material> e : this.materials.entrySet()) {
                if (replacements.containsKey((Object)e.getKey())) {
                    Texture current = e.getValue().getTexture();
                    Texture replacement = Texture.copyFrom(current);
                    String repPath = (String)replacements.get((Object)e.getKey());
                    if (repPath.startsWith("#")) {
                        if (this.materials.containsKey(repPath = repPath.substring(1))) {
                            replacement.setPath(this.materials.get(repPath).getTexture().getPath());
                        } else {
                            FMLLog.warning((String)"OBJModel.MaterialLibrary: Tried to set the texture path for material '%s' to the texture path of a non-existant material '%s', the original texture will be used.", (Object[])new Object[]{e.getKey(), repPath});
                        }
                    } else {
                        replacement.setPath(repPath);
                    }
                    Material repMat = Material.copyFrom(e.getValue());
                    repMat.setTexture(replacement);
                    mats.put(e.getKey(), repMat);
                    continue;
                }
                mats.put(e.getKey(), Material.copyFrom(e.getValue()));
            }
            MaterialLibrary ret = MaterialLibrary.copyFrom(this);
            ret.materials = mats;
            return ret;
        }

        public Map<String, Group> getGroups() {
            return this.groups;
        }

        public ImmutableMap<String, Group> getGroupsWithFaces() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, Group> e : this.groups.entrySet()) {
                if (e.getValue().faces.isEmpty()) continue;
                builder.put(e);
            }
            return builder.build();
        }

        public ImmutableList<String> getGroupNames() {
            return ImmutableList.copyOf(this.groups.keySet());
        }

        public List<Group> getGroupsContainingFace(Face f) {
            ArrayList groupList = Lists.newArrayList();
            for (Group g : this.groups.values()) {
                if (!g.faces.contains(f)) continue;
                groupList.add(g);
            }
            return groupList;
        }

        public Material getMaterial(String name) {
            return this.materials.get(name);
        }

        public ImmutableList<String> getMaterialNames() {
            return ImmutableList.copyOf(this.materials.keySet());
        }

        public static Vector3f[] getDefaultUVs(Pair<Boolean, Boolean> flip) {
            boolean u = flip != null ? (Boolean)flip.getLeft() : false;
            boolean v = flip != null ? (Boolean)flip.getRight() : false;
            Vector3f[] uvs = new Vector3f[]{new Vector3f(u ? 1.0f : 0.0f, v ? 0.0f : 1.0f, 1.0f), new Vector3f(u ? 0.0f : 1.0f, v ? 0.0f : 1.0f, 1.0f), new Vector3f(u ? 0.0f : 1.0f, v ? 1.0f : 0.0f, 1.0f), new Vector3f(u ? 1.0f : 0.0f, v ? 1.0f : 0.0f, 1.0f)};
            return uvs;
        }

        public void parseMaterials(IResourceManager manager, String libs, ResourceLocation from) throws IOException {
            String[] splitPath;
            this.materials.clear();
            this.initMaterialMap();
            for (String path : splitPath = WHITE_SPACE.split(libs)) {
                boolean hasSetTexture = false;
                boolean hasSetColor = false;
                String domain = from.func_110624_b();
                if (!path.contains("/")) {
                    path = from.func_110623_a().substring(0, from.func_110623_a().lastIndexOf("/") + 1) + path;
                }
                this.mtlStream = new InputStreamReader(manager.func_110536_a(new ResourceLocation(domain, path)).func_110527_b(), Charsets.UTF_8);
                this.mtlReader = new BufferedReader(this.mtlStream);
                String currentLine = "";
                Material material = new Material();
                while ((currentLine = this.mtlReader.readLine()) != null) {
                    if ((currentLine = currentLine.trim()).isEmpty() || currentLine.startsWith("#")) continue;
                    String[] fields = WHITE_SPACE.split(currentLine, 2);
                    String key = fields[0];
                    String data = fields[1];
                    if (key.equalsIgnoreCase("newmtl")) {
                        hasSetColor = false;
                        hasSetTexture = false;
                        material = new Material();
                        material.setName(data);
                        this.materials.put(data, material);
                        continue;
                    }
                    if (key.equalsIgnoreCase("Ka") || key.equalsIgnoreCase("Kd") || key.equalsIgnoreCase("Ks")) {
                        if (key.equalsIgnoreCase("Kd") || !hasSetColor) {
                            String[] rgbStrings = WHITE_SPACE.split(data, 3);
                            Vector4f color = new Vector4f(Float.parseFloat(rgbStrings[0]), Float.parseFloat(rgbStrings[1]), Float.parseFloat(rgbStrings[2]), 1.0f);
                            hasSetColor = true;
                            material.setColor(color);
                            continue;
                        }
                        FMLLog.info((String)"OBJModel: A color has already been defined for material '%s' in '%s'. The color defined by key '%s' will not be applied!", (Object[])new Object[]{material.getName(), new ResourceLocation(domain, path).toString(), key});
                        continue;
                    }
                    if (key.equalsIgnoreCase("map_Ka") || key.equalsIgnoreCase("map_Kd") || key.equalsIgnoreCase("map_Ks")) {
                        if (key.equalsIgnoreCase("map_Kd") || !hasSetTexture) {
                            if (data.contains(" ")) {
                                String[] mapStrings = WHITE_SPACE.split(data);
                                String texturePath = mapStrings[mapStrings.length - 1];
                                Texture texture = new Texture(texturePath);
                                hasSetTexture = true;
                                material.setTexture(texture);
                                continue;
                            }
                            Texture texture = new Texture(data);
                            hasSetTexture = true;
                            material.setTexture(texture);
                            continue;
                        }
                        FMLLog.info((String)"OBJModel: A texture has already been defined for material '%s' in '%s'. The texture defined by key '%s' will not be applied!", (Object[])new Object[]{material.getName(), new ResourceLocation(domain, path).toString(), key});
                        continue;
                    }
                    if (key.equalsIgnoreCase("d") || key.equalsIgnoreCase("Tr")) {
                        String[] splitData = WHITE_SPACE.split(data);
                        float alpha = Float.parseFloat(splitData[splitData.length - 1]);
                        material.getColor().setW(alpha);
                        continue;
                    }
                    if (this.unknownMaterialCommands.contains(key)) continue;
                    this.unknownMaterialCommands.add(key);
                    FMLLog.info((String)"OBJLoader.MaterialLibrary: key '%s' (model: '%s') is not currently supported, skipping", (Object[])new Object[]{key, new ResourceLocation(domain, path)});
                }
            }
        }
    }

    public static class Parser {
        private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
        private static Set<String> unknownObjectCommands = Sets.newHashSet();
        private MaterialLibrary materialLibrary = new MaterialLibrary();
        private IResourceManager manager;
        private InputStreamReader objStream;
        private BufferedReader objReader;
        private ResourceLocation objFrom;
        private List<String> groupList = Lists.newArrayList();
        private List<Vertex> vertices = Lists.newArrayList();
        private List<Vector3f> normals = Lists.newArrayList();
        private List<Vector3f> texCoords = Lists.newArrayList();

        public Parser(IResource from, IResourceManager manager) throws IOException {
            this.manager = manager;
            this.objFrom = from.func_177241_a();
            this.objStream = new InputStreamReader(from.func_110527_b(), Charsets.UTF_8);
            this.objReader = new BufferedReader(this.objStream);
        }

        public OBJModel parse() throws IOException {
            String currentLine = "";
            Material material = this.materialLibrary.getMaterial("OBJModel.Default.Texture.Name");
            int usemtlCounter = 0;
            float[][] parsedUVBounds = new float[][]{{0.0f, 0.0f}, {1.0f, 1.0f}};
            while ((currentLine = this.objReader.readLine()) != null) {
                float[] floatSplitData;
                if ((currentLine = currentLine.trim()).isEmpty() || currentLine.startsWith("#")) continue;
                String[] fields = WHITE_SPACE.split(currentLine, 2);
                String key = fields[0];
                String data = fields[1];
                String[] splitData = WHITE_SPACE.split(data);
                if (key.equalsIgnoreCase("mtllib")) {
                    this.materialLibrary.parseMaterials(this.manager, data, this.objFrom);
                    continue;
                }
                if (key.equalsIgnoreCase("usemtl")) {
                    material = data.equalsIgnoreCase("obj:white") ? this.materialLibrary.getMaterial("OBJModel.White.Texture.Name") : this.materialLibrary.getMaterial(data);
                    if (material == null) {
                        FMLLog.severe((String)"OBJLoader: Model '%s' tried to use a material that wasn't defined in its .mtl file, a plain white texture will be used instead!", (Object[])new Object[]{this.objFrom});
                        material = this.materialLibrary.getMaterial("OBJModel.White.Texture.Name");
                    }
                    ++usemtlCounter;
                    continue;
                }
                if (key.equalsIgnoreCase("v")) {
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    Vector4f pos = new Vector4f(floatSplitData[0], floatSplitData[1], floatSplitData[2], floatSplitData.length == 4 ? floatSplitData[3] : 1.0f);
                    Vertex vertex = new Vertex(pos, material);
                    this.vertices.add(vertex);
                    continue;
                }
                if (key.equalsIgnoreCase("vn")) {
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    Vector3f normal = new Vector3f(floatSplitData);
                    this.normals.add(normal);
                    continue;
                }
                if (key.equalsIgnoreCase("vt")) {
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    Vector3f texCoord = new Vector3f(floatSplitData[0], floatSplitData[1], floatSplitData.length == 3 ? floatSplitData[2] : 1.0f);
                    parsedUVBounds[0][0] = Math.min(parsedUVBounds[0][0], texCoord.x);
                    parsedUVBounds[1][0] = Math.max(parsedUVBounds[1][0], texCoord.x);
                    parsedUVBounds[0][1] = Math.min(parsedUVBounds[0][1], texCoord.y);
                    parsedUVBounds[1][1] = Math.max(parsedUVBounds[1][1], texCoord.y);
                    this.texCoords.add(texCoord);
                    continue;
                }
                if (key.equalsIgnoreCase("f")) {
                    String[][] splitSlash = new String[splitData.length][];
                    if (splitData.length > 4) {
                        FMLLog.warning((String)"OBJModel.Parser: found a face 'f' with more than 4 vertices, only the first 4 of these vertices will be rendered!", (Object[])new Object[0]);
                    }
                    int vert = 0;
                    int texCoord = 0;
                    int norm = 0;
                    ArrayList v = Lists.newArrayListWithCapacity((int)splitData.length);
                    for (int i = 0; i < splitData.length; ++i) {
                        Vertex newV;
                        if (splitData[i].contains("//")) {
                            splitSlash[i] = splitData[i].split("//");
                            vert = Integer.parseInt(splitSlash[i][0]);
                            vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                            norm = Integer.parseInt(splitSlash[i][1]);
                            norm = norm < 0 ? this.normals.size() - 1 : norm - 1;
                            newV = new Vertex(new Vector4f(this.vertices.get(vert).getPos()), this.vertices.get(vert).getMaterial());
                            newV.setNormal(this.normals.get(norm));
                            v.add(newV);
                            continue;
                        }
                        if (splitData[i].contains("/")) {
                            splitSlash[i] = splitData[i].split("/");
                            vert = Integer.parseInt(splitSlash[i][0]);
                            vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                            texCoord = Integer.parseInt(splitSlash[i][1]);
                            int n = texCoord = texCoord < 0 ? this.texCoords.size() - 1 : texCoord - 1;
                            if (splitSlash[i].length > 2) {
                                norm = Integer.parseInt(splitSlash[i][2]);
                                norm = norm < 0 ? this.normals.size() - 1 : norm - 1;
                            }
                            newV = new Vertex(new Vector4f(this.vertices.get(vert).getPos()), this.vertices.get(vert).getMaterial());
                            newV.setTextureCoordinate(this.texCoords.get(texCoord));
                            newV.setNormal(splitSlash[i].length > 2 ? this.normals.get(norm) : null);
                            v.add(newV);
                            continue;
                        }
                        vert = Integer.parseInt(splitData[i]);
                        vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                        newV = new Vertex(new Vector4f(this.vertices.get(vert).getPos()), this.vertices.get(vert).getMaterial());
                        v.add(newV);
                    }
                    Vertex[] va = new Vertex[v.size()];
                    v.toArray(va);
                    Face face = new Face(va, material.name);
                    if (usemtlCounter < this.vertices.size()) {
                        for (Vertex ver : face.getVertices()) {
                            ver.setMaterial(material);
                        }
                    }
                    if (this.groupList.isEmpty()) {
                        if (this.materialLibrary.getGroups().containsKey("OBJModel.Default.Group.Name")) {
                            this.materialLibrary.getGroups().get("OBJModel.Default.Group.Name").addFace(face);
                            continue;
                        }
                        Group def = new Group("OBJModel.Default.Group.Name", null);
                        def.addFace(face);
                        this.materialLibrary.getGroups().put("OBJModel.Default.Group.Name", def);
                        continue;
                    }
                    for (String s : this.groupList) {
                        if (this.materialLibrary.getGroups().containsKey(s)) {
                            this.materialLibrary.getGroups().get(s).addFace(face);
                            continue;
                        }
                        Group e = new Group(s, null);
                        e.addFace(face);
                        this.materialLibrary.getGroups().put(s, e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("g") || key.equalsIgnoreCase("o")) {
                    this.groupList.clear();
                    if (key.equalsIgnoreCase("g")) {
                        String[] splitSpace;
                        for (String s : splitSpace = WHITE_SPACE.split(data)) {
                            this.groupList.add(s);
                        }
                        continue;
                    }
                    this.groupList.add(data);
                    continue;
                }
                if (unknownObjectCommands.contains(key)) continue;
                unknownObjectCommands.add(key);
                FMLLog.info((String)"OBJLoader.Parser: command '%s' (model: '%s') is not currently supported, skipping", (Object[])new Object[]{key, this.objFrom});
            }
            if (!this.materialLibrary.getGroups().get("OBJModel.Default.Group.Name").hasFaces()) {
                this.materialLibrary.getGroups().remove("OBJModel.Default.Group.Name");
            }
            OBJModel model = new OBJModel(this.materialLibrary, this.objFrom, parsedUVBounds);
            return model;
        }
    }
}

