/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import journeymap.client.cartography.RGB;
import journeymap.client.log.JMLogger;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.logging.log4j.Logger;

public enum ColorHelper {
    INSTANCE;

    static List<EnumFacing> spriteFacings;
    Logger logger = Journeymap.getLogger();
    HashSet<BlockMD> failed = new HashSet();
    BlockColors blockColors = FMLClientHandler.instance().getClient().func_184125_al();
    HashMap<String, float[]> iconColorCache = new HashMap();

    public void resetIconColorCache() {
        this.iconColorCache.clear();
        this.failed.clear();
    }

    public boolean hasCachedIconColors() {
        return !this.iconColorCache.isEmpty();
    }

    public int cachedIconColors() {
        return this.iconColorCache.size();
    }

    public boolean failedFor(BlockMD blockMD) {
        return this.failed.contains(blockMD);
    }

    public int getColorMultiplier(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        if (chunkMD == null || !chunkMD.hasChunk()) {
            return this.blockColors.func_186724_a(blockMD.getBlockState(), (IBlockAccess)JmBlockAccess.INSTANCE, blockPos, 2);
        }
        IBlockState blockState = chunkMD.getChunk().func_177435_g(blockPos);
        if (Blocks.field_150350_a.func_176223_P().equals(blockState)) {
            return 0xFFFFFF;
        }
        return this.blockColors.func_186724_a(blockMD.getBlockState(), (IBlockAccess)JmBlockAccess.INSTANCE, blockPos, 2);
    }

    public int getMapColor(BlockMD blockMD) {
        return blockMD.getBlockState().func_185904_a().func_151565_r().field_76291_p;
    }

    public Integer getTextureColor(BlockMD blockMD) {
        try {
            this.setBlockColor(blockMD, this.getDirectIcon(blockMD));
            return blockMD.getColor();
        }
        catch (Throwable t) {
            this.failed.add(blockMD);
            if (blockMD.getUid().startsWith("minecraft")) {
                this.logger.warn(String.format("Error getting block color for %s. Cause: %s", blockMD, LogFormatter.toPartialString(t)));
            }
            return null;
        }
    }

    private TextureAtlasSprite getDirectIcon(BlockMD blockMD) {
        IBlockState blockState = blockMD.getBlockState();
        Block block = blockState.func_177230_c();
        if (block instanceof BlockDoublePlant && ((BlockDoublePlant.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockDoublePlant.field_176492_b)).toString().equals("lower")) {
            blockState = blockState.func_177231_a((IProperty)BlockDoublePlant.field_176492_b);
        }
        if (block instanceof IFluidBlock) {
            ResourceLocation loc = ((IFluidBlock)block).getFluid().getStill();
            TextureAtlasSprite tas = FMLClientHandler.instance().getClient().func_147117_R().func_110572_b(loc.toString());
            return tas;
        }
        if (blockState.func_185904_a() == Material.field_151577_b) {
            blockMD.addFlags(BlockMD.Flag.Grass);
        }
        ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>(2);
        for (Map.Entry entry : blockState.func_177228_b().entrySet()) {
            if (!(entry.getKey() instanceof PropertyDirection)) continue;
            facings.addAll(spriteFacings);
            facings.retainAll(((IProperty)entry.getKey()).func_177700_c());
            break;
        }
        return this.getFirstFoundSprite(blockState, facings);
    }

    private TextureAtlasSprite getFirstFoundSprite(IBlockState blockState, ArrayList<EnumFacing> facing) {
        BlockModelShapes bms = FMLClientHandler.instance().getClient().func_175602_ab().func_175023_a();
        for (EnumFacing face : facing) {
            try {
                TextureAtlasSprite sprite;
                IBakedModel model = bms.func_178125_b(blockState);
                if (model == null) continue;
                List quads = null;
                try {
                    quads = model.func_188616_a(blockState, face, 0L);
                }
                catch (Exception e) {
                    JMLogger.logOnce("Error calling " + model.getClass().getName() + ".getQuads()", e);
                    break;
                }
                if (quads.isEmpty() || new ResourceLocation((sprite = ((BakedQuad)quads.get(0)).func_187508_a()).func_94215_i()).equals((Object)TextureMap.field_174945_f)) continue;
                if (Journeymap.getLogger().isDebugEnabled()) {
                    Journeymap.getLogger().info("Using face %s for block color in %s", new Object[]{face, blockState});
                }
                return sprite;
            }
            catch (Exception e) {
                Journeymap.getLogger().error(String.format("Error getting EnumFacing.%s for %s:\n%s\n\t%s\n\t%s", face, blockState, e, e.getStackTrace()[0], e.getStackTrace()[1]));
            }
            break;
        }
        if (Journeymap.getLogger().isDebugEnabled()) {
            Journeymap.getLogger().debug("Using particle texture for block color in %s", new Object[]{blockState});
        }
        return bms.func_178122_a(blockState);
    }

    private void setBlockColorToError(BlockMD blockMD) {
        blockMD.setAlpha(0.0f);
        blockMD.addFlags(BlockMD.Flag.HasAir, BlockMD.Flag.Error);
        blockMD.setColor(null);
        this.failed.add(blockMD);
    }

    private void setBlockColorToAir(BlockMD blockMD) {
        blockMD.setAlpha(0.0f);
        blockMD.addFlags(BlockMD.Flag.HasAir);
        blockMD.setColor(0xFFFFFF);
    }

    private void setBlockColorToMaterial(BlockMD blockMD) {
        try {
            blockMD.setAlpha(1.0f);
            blockMD.addFlags(BlockMD.Flag.HasAir);
            blockMD.setColor(this.getMapColor(blockMD));
        }
        catch (Exception e) {
            this.logger.warn(String.format("Failed to use MaterialMapColor, marking as error: %s", blockMD));
            this.setBlockColorToError(blockMD);
        }
    }

    private boolean setBlockColor(BlockMD blockMD, BufferedImage textureImg, String pass) {
        try {
            if (textureImg == null || textureImg.getWidth() == 0) {
                Journeymap.getLogger().warn(String.format("ColorHelper.setBlockColor(pass=" + pass + "): Null/empty texture for %s", blockMD));
                return false;
            }
            float[] rgba = this.getAverageColor(blockMD, textureImg);
            if (this.setBlockColor(blockMD, rgba, pass)) {
                this.iconColorCache.put(blockMD.getIconName(), rgba);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.logger.error(String.format("ColorHelper.setBlockColor(pass=" + pass + "): Error for %s", blockMD));
            this.logger.error(LogFormatter.toPartialString(e));
            return false;
        }
    }

    private boolean setBlockColor(BlockMD blockMD, float[] rgba, String pass) {
        try {
            if (rgba.length < 4) {
                Journeymap.getLogger().debug(String.format("ColorHelper.setBlockColor(pass=" + pass + "): Couldn't derive RGBA from %s", blockMD));
                return false;
            }
            int color = RGB.toInteger(rgba);
            float blockAlpha = blockMD.hasTransparency() ? blockMD.getAlpha() : rgba[3];
            blockMD.setColor(color);
            blockMD.setAlpha(blockAlpha);
            return true;
        }
        catch (Exception e) {
            this.logger.error(String.format("ColorHelper.setBlockColor(pass=" + pass + "): Error for %s", blockMD));
            this.logger.error(LogFormatter.toPartialString(e));
            return false;
        }
    }

    private void setBlockColor(BlockMD blockMD, TextureAtlasSprite icon) {
        try {
            if (icon == null) {
                if (blockMD.getBlockState().func_177230_c() instanceof ITileEntityProvider) {
                    this.logger.debug("Ignoring TitleEntity without standard block texture: " + blockMD);
                    blockMD.addFlags(BlockMD.Flag.TileEntity);
                    this.setBlockColorToAir(blockMD);
                } else {
                    this.setBlockColorToError(blockMD);
                }
                return;
            }
            String iconName = icon.func_94215_i();
            blockMD.setIconName(iconName);
            if (this.iconColorCache.containsKey(iconName)) {
                float[] rgba = this.iconColorCache.get(iconName);
                if (this.setBlockColor(blockMD, rgba, "cache")) {
                    return;
                }
                this.iconColorCache.remove(iconName);
            }
            if (blockMD.getBlockState().func_185901_i() == EnumBlockRenderType.INVISIBLE) {
                this.setBlockColorToAir(blockMD);
                return;
            }
            if (Material.field_151579_a.equals(blockMD.getBlockState().func_185904_a())) {
                this.setBlockColorToAir(blockMD);
                return;
            }
            if (new ResourceLocation(iconName).equals((Object)TextureMap.field_174945_f)) {
                this.setBlockColorToMaterial(blockMD);
                return;
            }
            if (this.setBlockColor(blockMD, this.getImageFromFrameTextureData(icon), "frameTextureData")) {
                return;
            }
            if (this.setBlockColor(blockMD, this.getImageFromResourceLocation(icon), "resourceLocation")) {
                return;
            }
            this.logger.debug(String.format("ColorHelper.setBlockColor(): Texture unusable. Using MaterialMapColor instead for: %s", blockMD));
            this.setBlockColorToMaterial(blockMD);
        }
        catch (Throwable e1) {
            this.logger.debug("Error deriving color for " + blockMD + ": " + LogFormatter.toString(e1));
            this.setBlockColorToMaterial(blockMD);
        }
    }

    private BufferedImage getImageFromFrameTextureData(TextureAtlasSprite tas) {
        try {
            int[] rgb = tas.func_147965_a(0)[0];
            if (rgb.length > 0) {
                int width = tas.func_94211_a();
                int height = tas.func_94216_b();
                BufferedImage textureImg = new BufferedImage(width, height, 2);
                textureImg.setRGB(0, 0, width, height, rgb, 0, width);
                return textureImg;
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("ColorHelper.getColorForIcon(): Unable to use frame data for %s: %s", tas.func_94215_i(), t.getMessage()));
        }
        return null;
    }

    private BufferedImage getImageFromResourceLocation(TextureAtlasSprite tas) {
        try {
            ResourceLocation iconNameLoc = new ResourceLocation(tas.func_94215_i());
            ResourceLocation fileLoc = new ResourceLocation(iconNameLoc.func_110624_b(), "textures/" + iconNameLoc.func_110623_a() + ".png");
            return TextureCache.resolveImage(fileLoc);
        }
        catch (Throwable t) {
            Journeymap.getLogger().debug(String.format("ColorHelper.getColorForIcon(): Unable to use texture file for %s: %s", tas.func_94215_i(), t.getMessage()));
            return null;
        }
    }

    private float[] getAverageColor(BlockMD blockMD, BufferedImage textureImg) {
        int count = 0;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int x = 0;
        int y = 0;
        int yStart = 0;
        int xStart = 0;
        int xStop = textureImg.getWidth();
        int yStop = textureImg.getHeight();
        try {
            boolean unusable = true;
            block5: for (x = xStart; x < xStop; ++x) {
                for (y = yStart; y < yStop; ++y) {
                    int argb;
                    try {
                        argb = textureImg.getRGB(x, y);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.logger.warn("Bad index at " + x + "," + y + " for " + blockMD + ": " + e.getMessage());
                        continue;
                    }
                    catch (Throwable e) {
                        this.logger.debug("Couldn't get RGB from BlocksTexture at " + x + "," + y + " for " + blockMD + ": " + e.getMessage());
                        break block5;
                    }
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    ++count;
                    a += alpha;
                    r += argb >> 16 & 0xFF;
                    g += argb >> 8 & 0xFF;
                    b += argb & 0xFF;
                }
            }
            if (count > 0) {
                if (a > 0) {
                    a /= count;
                }
                if (r > 0) {
                    r /= count;
                }
                if (g > 0) {
                    g /= count;
                }
                if (b > 0) {
                    b /= count;
                }
                return RGB.floats(RGB.toInteger(r, g, b), a);
            }
            this.logger.debug("Texture was completely transparent for " + blockMD);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("ColorHelper.getAverageColor(): Error getting average color: %s", t.getMessage()));
        }
        return new float[0];
    }

    static {
        spriteFacings = Arrays.asList(EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST);
    }
}

