/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.fluid.FluidHandlerEmperorChalice;
import xreliquary.reference.Settings;
import xreliquary.util.RegistryHelper;

public class ItemEmperorChalice
extends ItemToggleable {
    public ItemEmperorChalice() {
        super("emperor_chalice");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerEmperorChalice(stack);
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.DRINK;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (world.field_72995_K) {
            return stack;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        int multiplier = Settings.EmperorChalice.hungerSatiationMultiplier;
        player.func_71024_bL().func_75122_a(1, (float)(multiplier / 2));
        player.func_70097_a(DamageSource.field_76369_e, (float)multiplier);
        return stack;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return super.func_77659_a(ist, world, player, hand);
        }
        float coeff = 1.0f;
        double xOff = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)coeff;
        double yOff = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)coeff + (double)player.func_70047_e();
        double zOff = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)coeff;
        boolean isInDrainMode = this.isEnabled(ist);
        RayTraceResult result = this.func_77621_a(world, player, isInDrainMode);
        if (result == null) {
            if (!this.isEnabled(ist)) {
                player.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
        }
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!world.func_175660_a(player, result.func_178782_a())) {
                return new ActionResult(EnumActionResult.FAIL, (Object)ist);
            }
            if (!player.func_175151_a(result.func_178782_a(), result.field_178784_b, ist)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)ist);
            }
            if (!this.isEnabled(ist)) {
                BlockPos waterPlacementPos = result.func_178782_a().func_177972_a(result.field_178784_b);
                if (!player.func_175151_a(waterPlacementPos, result.field_178784_b, ist)) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)ist);
                }
                if (this.tryPlaceContainedLiquid(world, ist, xOff, yOff, zOff, waterPlacementPos)) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
                }
            } else {
                String ident = RegistryHelper.getBlockRegistryName(world.func_180495_p(result.func_178782_a()).func_177230_c());
                if ((ident.equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150358_i)) || ident.equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150355_j))) && (Integer)world.func_180495_p(result.func_178782_a()).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    world.func_175656_a(result.func_178782_a(), Blocks.field_150350_a.func_176223_P());
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)ist);
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack stack, double posX, double posY, double posZ, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Material material = blockState.func_177230_c().func_149688_o(blockState);
        if (this.isEnabled(stack)) {
            return false;
        }
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        if (world.field_73011_w.func_177500_n()) {
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int var11 = 0; var11 < 8; ++var11) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P(), 3);
        }
        return true;
    }
}

